#! /bin/sh

main() {

##### 初期設定 #####
LOOP_NUM=12
ROOT_PASSWORD=root

##### 引数取得 #####
TMP_DIR=$1
SRC_DIR=$2
BUILD_XML=$3
JBOSS_HOME=$4

##### 初期設定 #####
TMP_DIR=${TMP_DIR}/
SRC_DIR=${SRC_DIR}/

##### MySQL起動 #####
/usr/local/mysql/bin/mysqld_safe &
for i in `seq 1 ${LOOP_NUM}`; do
	sleep 5
	/usr/local/mysql/bin/mysqladmin -u root -p${ROOT_PASSWORD} status > /dev/nul
	EXIT_CODE=$?
	if [ "${EXIT_CODE}" = "0" ]; then
		echo MySQLの起動確認ができました。
		break
	else
		if [ "${i}" = "${LOOP_NUM}" ]; then
			echo MySQLの起動確認ができませんでした。
			break
		fi
		echo "MySQLの起動確認ができないためリトライします。(${i})"
	fi
done

##### インストール #####
cp -pf ${SRC_DIR}${BUILD_XML} ${TMP_DIR}
cd ${TMP_DIR}
ant -DjbossHome=${JBOSS_HOME} -f ${BUILD_XML}

##### MySQL停止 #####
/usr/local/mysql/bin/mysqladmin -u root -p${ROOT_PASSWORD} shutdown

}

main $*
