#! /bin/sh

main() {

##### 初期設定 #####
BIN_DIR=bin
POSTGRES_EXE=postgres

##### 引数取得 #####
PRODUCT_NAME=$1
PRODUCT_VER=$2
POSTGRES_HOME=$3

##### 初期処理 #####
POSTGRES_HOME=${POSTGRES_HOME}/

##### バージョンチェック #####
cd "${POSTGRES_HOME}${BIN_DIR}"
if [ ! -f "${POSTGRES_EXE}" ]; then
	echo ${POSTGRES_EXE}は、インストールされていません。
	exit 1
fi
INSTALLED_VER=`sudo -u postgres "./${POSTGRES_EXE}" --version | awk '{print $3;}'`
if [ "${INSTALLED_VER}" = "${PRODUCT_VER}" ]; then
	echo "${PRODUCT_NAME}は、最新版がインストールされています。(Ver.${INSTALLED_VER})"
	exit 1
fi
if [ "${INSTALLED_VER}" = "8.3.x" ]; then
	echo "処理なし" > /dev/nul
else
	echo "${PRODUCT_NAME}は、アップデート対象のバージョンではありません。(Ver.${INSTALLED_VER})"
	exit 1
fi

##### アップデート #####
echo "${PRODUCT_NAME}のアップデート処理をします。(Ver.${INSTALLED_VER} -> Ver.${PRODUCT_VER})"
exit 0

}

main $*
