#! /bin/sh

main() {

##### 初期設定 #####
OS_LANG=UTF-8
OPENSTANDIA_INSTALLER_VER=3.0.0
STACK_XML=stack-${OPENSTANDIA_INSTALLER_VER}.xml
LICENSE_FILE=license.txt
ANT_DIR=apache-ant-1.7.0
SCRIPTS_DIR=scripts
APACHE_NO=2
JBOSS_NO=4
MOD_JK_NO=6
MYSQL_NO=8
POSTGRESQL_NO=16
PET_STORE_SSH_NO=10
PET_STORE_SEASAR2_NO=20
JBOSS_ESB_NO=14
APACHE_TOMCAT_NO=12


##### 初期処理 #####
CURRENT_DIR=`pwd`
BASEDIR=`dirname $0`
if [ "${CURRENT_DIR}" = "/" ]; then
	CURRENT_DIR=${BASEDIR}
else
	CURRENT_DIR=${CURRENT_DIR}/${BASEDIR}
fi
_ANT_HOME=${ANT_HOME}
ANT_HOME=${CURRENT_DIR}/lib/${ANT_DIR}
export ANT_HOME
_PATH=${PATH}
PATH=${ANT_HOME}/bin:${CURRENT_DIR}/bin:${PATH}
export PATH
_SCRIPTS_DIR=${SCRIPTS_DIR}
SCRIPTS_DIR=${CURRENT_DIR}/${SCRIPTS_DIR}/
export SCRIPTS_DIR

chmod 755 "${ANT_HOME}/bin/ant" > /dev/nul
set_lang_func


##### 実行ユーザー権限チェック #####
sh ${CURRENT_DIR}/bin/CheckAuthority.sh
if [ $? -ne 0 ]; then
	echo 実行ユーザーがrootでないため処理を続行できません。
	end_func
fi


##### javaインストールチェック #####
sh ${CURRENT_DIR}/bin/CheckInstalledJava.sh
if [ $? -ne 0 ]; then
	echo javaがインストールされていないかもしくは、javaにパスが通っていないため処理を続行できません。
	end_func
fi


##### 画面表示 #####
clear
echo OpenStandia Ver.${OPENSTANDIA_INSTALLER_VER}
echo 各種OSSのインストール、アンインストール、アップデート処理をします。
echo 
echo 処理を選択してください。
echo 1 : インストール
echo 2 : アンインストール
echo 3 : アップデート
read MODE_NO
if [ "${MODE_NO}" = "" ]; then
	MODE_NO=1
fi
if [ "${MODE_NO}" = "1" ]; then
	MODE=install
	MODE_STR=インストール
fi
if [ "${MODE_NO}" = "2" ]; then
	MODE=uninstall
	MODE_STR=アンインストール
fi
if [ "${MODE_NO}" = "3" ]; then
	MODE=update
	MODE_STR=アップデート
fi


##### ライセンス表示 ######
if [ "${MODE}" = "install" ]; then
	clear
	iconv -f SHIFT_JIS -t ${OS_LANG} "${CURRENT_DIR}/${LICENSE_FILE}" | more
	read -p "同意しますか？(y/n) [n]" RESULT
	if [ "${RESULT}" = "y" ]; then
		echo 処理を継続します。 > /dev/nul
	else
		end_func
	fi
fi


##### インストール全体前処理 #####
echo 
ant -Dmode=${MODE} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install-before.xml"
if [ $? -ne 0 ]; then error_func; fi


##### 問い合わせ #####
clear
# Apache
read -p "Apacheを${MODE_STR}しますか？(y/n) [y]" INSTALL_APACHE
if [ "${INSTALL_APACHE}" = "" ]; then
	INSTALL_APACHE=y
fi
INSTALL_APACHE_CONF=0
if [ "${MODE}" = "install" ]; then
	if [ "${INSTALL_APACHE}" = "y" ]; then
		echo Apache用の設定ファイル\(httpd.conf\)を選択してください。
		echo 1 : デフォルト
		echo 2 : 推奨設定
		read INSTALL_APACHE_CONF
	fi
fi

# JBoss
read -p "JBossを${MODE_STR}しますか？(y/n) [y]" INSTALL_JBOSS
if [ "${INSTALL_JBOSS}" = "" ]; then
	INSTALL_JBOSS=y
fi

# mod_jk
read -p "mod_jkを${MODE_STR}しますか？(y/n) [y]" INSTALL_MOD_JK
if [ "${INSTALL_MOD_JK}" = "" ]; then
	INSTALL_MOD_JK=y
fi

# MySQL
read -p "MySQLを${MODE_STR}しますか？(y/n) [y]" INSTALL_MYSQL
if [ "${INSTALL_MYSQL}" = "" ]; then
	INSTALL_MYSQL=y
fi

# PostgreSQL
read -p "PostgreSQLを${MODE_STR}しますか？(y/n) [y]" INSTALL_POSTGRESQL
if [ "${INSTALL_POSTGRESQL}" = "" ]; then
	INSTALL_POSTGRESQL=y
fi

# petStore(Struts、Spring、Hibernate)
read -p "Struts、Spring、Hibernateによるサンプルを${MODE_STR}しますか？(y/n) [y]" INSTALL_PET_STORE_SSH
if [ "${INSTALL_PET_STORE_SSH}" = "" ]; then
	INSTALL_PET_STORE_SSH=y
fi

# petStore(Seasar2、SAStruts)
read -p "Seasar2、SAStrutsによるサンプルを${MODE_STR}しますか？(y/n) [y]" INSTALL_PET_STORE_SEASAR2
if [ "${INSTALL_PET_STORE_SEASAR2}" = "" ]; then
	INSTALL_PET_STORE_SEASAR2=y
fi

# JBossESB
read -p "JBossESBを${MODE_STR}しますか？(y/n) [y]" INSTALL_JBOSS_ESB
if [ "${INSTALL_JBOSS_ESB}" = "" ]; then
	INSTALL_JBOSS_ESB=y
fi

# apache-tomcat
read -p "Apache-Tomcat連携を${MODE_STR}しますか？(y/n) [y]" INSTALL_APACHE_TOMCAT
if [ "${INSTALL_APACHE_TOMCAT}" = "" ]; then
	INSTALL_APACHE_TOMCAT=y
fi


##### ant実行 #####
echo 
echo ダウンロード処理を開始します...
if [ "${INSTALL_APACHE}" = "y" ]; then
	ant -Dno=${APACHE_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_JBOSS}" = "y" ]; then
	ant -Dno=${JBOSS_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_MOD_JK}" = "y" ]; then
	ant -Dno=${MOD_JK_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_MYSQL}" = "y" ]; then
	ant -Dno=${MYSQL_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_POSTGRESQL}" = "y" ]; then
	ant -Dno=${POSTGRESQL_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_PET_STORE_SSH}" = "y" ]; then
	ant -Dno=${PET_STORE_SSH_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_PET_STORE_SEASAR2}" = "y" ]; then
	ant -Dno=${PET_STORE_SEASAR2_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_JBOSS_ESB}" = "y" ]; then
	ant -Dno=${JBOSS_ESB_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_APACHE_TOMCAT}" = "y" ]; then
	ant -Dno=${APACHE_TOMCAT_NO} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}download.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi

INSTALLED_NO=
echo 
echo ${MODE_STR}処理を開始します...
if [ "${INSTALL_APACHE}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${APACHE_NO}
	ant -Dno=${APACHE_NO} -Dsub=${INSTALL_APACHE_CONF} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_JBOSS}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${JBOSS_NO}
	ant -Dno=${JBOSS_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_MOD_JK}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${MOD_JK_NO}
	ant -Dno=${MOD_JK_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_MYSQL}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${MYSQL_NO}
	ant -Dno=${MYSQL_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_POSTGRESQL}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${POSTGRESQL_NO}
	ant -Dno=${POSTGRESQL_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_PET_STORE_SSH}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${PET_STORE_SSH_NO}
	ant -Dno=${PET_STORE_SSH_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_PET_STORE_SEASAR2}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${PET_STORE_SEASAR2_NO}
	ant -Dno=${PET_STORE_SEASAR2_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_JBOSS_ESB}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${JBOSS_ESB_NO}
	ant -Dno=${JBOSS_ESB_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi
if [ "${INSTALL_APACHE_TOMCAT}" = "y" ]; then
	INSTALLED_NO=${INSTALLED_NO},${APACHE_TOMCAT_NO}
	ant -Dno=${APACHE_TOMCAT_NO} -Dmode=${MODE} -DinstalledNo="${INSTALLED_NO}" -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install.xml"
	if [ $? -ne 0 ]; then error_func; fi
fi


##### インストール全体後処理 #####
echo 
ant -Dmode=${MODE} -DstackXml=${STACK_XML} -f "${SCRIPTS_DIR}install-after.xml"
if [ $? -ne 0 ]; then error_func; fi


##### 後処理 #####
end_func

}


##### 終了処理 #####
finally_func () {
	ANT_HOME=${_ANT_HOME}
	export ANT_HOME
	PATH=${_PATH}
	export PATH
	SCRIPTS_DIR=${_SCRIPTS_DIR}
	export SCRIPTS_DIR

	echo ${MODE_STR}処理を終了しました...
}


##### 正常終了 #####
end_func () {
	finally_func
	exit 0
}


##### 異常終了 #####
error_func () {
	echo ${MODE_STR}処理の途中で異常が発生しました...
	finally_func
	exit 1
}


##### 文字コード設定 #####
set_lang_func () {
	_OS_LANG=`echo ${LANG} | awk -F '.' '{print $2;}'`
	if [ "${_OS_LANG}" = "" ]; then
		echo 処理なし > /dev/nul
	else
		OS_LANG=${_OS_LANG}
	fi
}

main $*
