#!/bin/sh

# This is where the SD card is mounted.
# change if you use CF card or something other.
CARD_TOP_DIR=/media/card

LOCALIZE_TOP_DIR=$CARD_TOP_DIR/x11-image-localize-ja

ORIG_SHARE=/usr/share
TARGET_SHARE_DIR=/home/share
# move share directory to home partition
if [ ! -L $ORIG_SHARE ] ; then
	cd /usr
	if [ -d $TARGET_SHARE_DIR ] ; then
		rm -rf $TARGET_SHARE_DIR
	fi
	mv $ORIG_SHARE $TARGET_SHARE_DIR
	ln -s $TARGET_SHARE_DIR .
fi

# install additional message catalog packages.
ipkg install $LOCALIZE_TOP_DIR/ja-mo-pkg/*.ipk

# install additional font packages.
ipkg install $LOCALIZE_TOP_DIR/ja-font-pkg/*.ipk

# install additional glibc-gconv packages.
ipkg install $LOCALIZE_TOP_DIR/ja-glibc-pkg/*.ipk

## install Japanese message catalogue
JA_MO=`ls $LOCALIZE_TOP_DIR/ja-mo/*.mo 2> /dev/null`
if [ -n "$JA_MO" ] ; then
	cp $JA_MO /usr/share/locale/ja/LC_MESSAGES
fi

# for gpe-login.
echo '"Japanese (Japan) UTF-8" ja_JP' >> /etc/gpe/locale.alias

cat << MEND
Run: 
  gpe-conf theme
to set font from tabs 'Fonts' and 'Terminal'.
Then logout, login, you will see Japanese characters.
MEND
