/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @file entryPrtLocalization.h
 * @brief Type definitons of EntryPrtLocalization object.
 * @date $Date: 2004/10/22 08:32:53 $
 * @version $Revision: 1.1.1.1 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#ifndef ENTRY_PRTLOCALIZATION_H
#define ENTRY_PRTLOCALIZATION_H

#include <bidiTypes.h>

#ifdef __cplusplus
extern "C" {
#endif

  /**
   * The structure that containing the PrtLocalizatonEntry messages.
   *
   * @struct EntryPrtLocalization.
   */
  typedef struct {
    OSTRING *PrtLocLang;    /**< PrtLocalizationLanguage message. */
    CCHARSET PrtLocCharSet; /**< PrtLocalizationCharacterSet message. */
  } EntryPrtLocalization;

  // Prototypes
  EntryPrtLocalization *newEntryPrtLoc(void);
  void deleteEntryPrtLoc(EntryPrtLocalization *);
  void setEntryPrtLoc(EntryPrtLocalization*,xmlChar*, xmlChar *);

#ifdef __cplusplus
}
#endif

#endif
