/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @file entryPrtMarkerSupplies.h
 * @brief Type definitions for EntryPrtMarkerSupplies object.
 * @date $Date: 2004/10/22 08:32:53 $
 * @version $Revision: 1.1.1.1 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#ifndef ENTRY_PRTMARKERSUPPLIES_H
#define ENTRY_PRTMARKERSUPPLIES_H

#include <bidiTypes.h>

#ifdef __cplusplus
extern "C" {
#endif

  /**
   * PrtMarkerSuppliesIndex enumeration.
   *
   * @enum enumPrtMarkSupIndex.
   */
  typedef enum {
    PRTMARK_INDEX_C = 1,
    PRTMARK_INDEX_M = 2,
    PRTMARK_INDEX_Y = 3,
    PRTMARK_INDEX_K = 4
  }enumPrtMarkSupIndex;

  /**
   * PrtMarkerSuppliesType enumeration.
   *
   * @enum enumPrtMarkSupType.
   */
  typedef enum {
    PRTMARK_SUPTYPE_OTHER         = 1,
    PRTMARK_SUPTYPE_UNKNOWN       = 2,
    PRTMARK_SUPTYPE_TONER         = 3,
    PRTMARK_SUPTYPE_WASTE_TONNER  = 4,
    PRTMARK_SUPTYPE_INK           = 5,
    PRTMARK_SUPTYPE_INK_CARTRIDGE = 6,
    PRTMARK_SUPTYPE_INK_RIBON     = 7,
    PRTMARK_SUPTYPE_WASTE_INK     = 8,
    PRTMARK_SUPTYPE_OPC           = 9,
    PRTMARK_SUPTYPE_DEVELOPER     = 10,
    PRTMARK_SUPTYPE_FUSER_OIL     = 11,
    PRTMARK_SUPTYPE_SOLID_WAX     = 12,
    PRTMARK_SUPTYPE_RIBBON_WAX    = 13,
    PRTMARK_SUPTYPE_WASTE_WAX     = 14
  }enumPrtMarkSupType;
  
  /**
   * PrtMarkerSuppliesSupplyUnit enumeration.
   *
   * @enum enumPrtMarkSupSupUnit.
   */
  typedef enum {
    PRTMARK_SUPUNIT_INCH        = 3,
    PRTMARK_SUPUNIT_MICRO_METER = 4,
    PRTMARK_SUPUNIT_OUNCE       = 12,
    PRTMARK_SUPUNIT_GRAM        = 13,
    PRTMARK_SUPUNIT_FLUID_OUNCE = 14,
    PRTMARK_SUPUNIT_MILI_LITER  = 15,
    PRTMARK_SUPUNIT_PERCENT     = 19
  }enumPrtMarkSupSupUnit;

  /**
   * The structure that containing the PrtMarkerSuppliesEntry messages.
   *
   * @struct EntryPrtMarkerSupplies.
   */
  typedef struct _EntryPrtMarkerSupplies {
    struct _EntryPrtMarkerSupplies *next;   /**< link to self. */
    enumPrtMarkSupIndex PrtMarkSupIndex;    /**< PrtMarkerSuppliesIndex enumeration. */
    enumPrtMarkSupType PrtMarkSupType;      /**< PrtMarkerSuppliesType enumeration. */
    OSTRING *PrtMarkSupDesc;                /**< PrtMarkerSuppliesDescription message. */
    enumPrtMarkSupSupUnit PrtMarkSupSupUnit;/**< PrtMarkerSuppliesSupplyUnit enumeration. */
    INT32 PrtMarkSupMaxCap;                 /**< PrtMarkerSuppliesMaxCapacity value. */
    INT32 PrtMarkSupLevel;                  /**< PrtMarkerSuppliesLevel value. */
  } EntryPrtMarkerSupplies;

  // Prototypes
  EntryPrtMarkerSupplies *newEntryPrtMarkSupp(void);
  void deleteEntryPrtMarkSupp(EntryPrtMarkerSupplies*);
  EntryPrtMarkerSupplies *addEntryPrtMarkSupp(EntryPrtMarkerSupplies*);
  void setEntryPrtMarkSupp(EntryPrtMarkerSupplies*,xmlChar*,xmlChar*);

#ifdef __cplusplus
}
#endif

#endif
