/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

/**
 * @ingroup bidiformat
 * @file parserPrtLocalization.c
 * @brief parse PrtLocalizationEntry.
 * @date $Date: 2004/10/22 08:32:53 $
 * @version $Revision: 1.1.1.1 $
   copyright            : (C) 2004 by Turbolinux,Inc.
*/

#include <libxml/xmlreader.h>

#include "bidiParser.h"
#include "entryPrtLocalization.h"

//Prototypes
void parseNodePrtLocalization(Parser*,Entry*);

/**
  * parse XML data and set data to Entry object especially PrtLocalizationEntry.
  *
  * @param parser Pointer to Parser object.
  * @param entry Pointer to Entry object.
  * @return None.
  */
void parseNodePrtLocalization(Parser *parser,Entry *entry)
{
  xmlElementType node_type;
  xmlNodePtr cur_node;
  xmlChar *element_name;
  xmlChar *data;
  
  node_type = xmlTextReaderNodeType(parser->reader);
  element_name = xmlTextReaderName(parser->reader);
  
  if (node_type == XML_READER_TYPE_ELEMENT) { /* in case start of tag */
    
    switch(parser->state){
    case STATE_START:
      //    case STATE_PRINTER_MIB:
      if (xmlStrcmp(element_name, "PrtLocalizationTable") == 0)	{
	parser->state = STATE_LOC_TABLE;
      }
      break;
    case STATE_LOC_TABLE:
      if (xmlStrcmp(element_name, "PrtLocalizationEntry") == 0) {
	parser->state = STATE_LOC_ENTRY;
	entry->EntryPrtLocalizationPtr = newEntryPrtLoc();
      }
      break;
    case STATE_LOC_ENTRY:
      if (xmlStrcmp(element_name, "PrtLocalizationLanguage") == 0) {
	parser->state = STATE_LOC_LANG; 
      } else if (xmlStrcmp(element_name, "PrtLocalizationCharacterSet") == 0) {
	parser->state = STATE_LOC_CHARSET;
      }
      break;
    }
    
  } else if (node_type == XML_READER_TYPE_END_ELEMENT){ /* in case end of tag */
    
    switch(parser->state){
    case STATE_LOC_TABLE:
      parser->state = STATE_START;
      //      parser->state = STATE_PRINTER_MIB;
      break;
    case STATE_LOC_ENTRY:
      parser->state = STATE_LOC_TABLE;
      break;
    case STATE_LOC_LANG:
    case STATE_LOC_CHARSET:
      parser->state = STATE_LOC_ENTRY;
      break;
    }
    
  } else if (node_type == XML_READER_TYPE_TEXT){ /* in case text value */
    switch(parser->state){
    case STATE_LOC_CHARSET:
    case STATE_LOC_LANG:
      cur_node = xmlTextReaderCurrentNode(parser->reader);
      data = xmlTextReaderValue(parser->reader);
      setEntryPrtLoc(entry->EntryPrtLocalizationPtr,cur_node->parent->name,data);
      break;
    }
  }
}
