# -*- coding:utf-8-unix -*-
#
# Copyright (c) 2000-2003 Turbolinux, inc. 
# This file and all modifications and/or additions are under 
# the same license as package itself.

%define _name opfc-BidiBackend
%define _ver  1.0.2
%define _rel  2
%define opfc_prefix opfc-

Summary: OpenPrinting Japan - CUPS backend with Bidi status read support
Summary(ja_JP.utf8): BidiをサポートしたCUPS用バックエンド
Name: %{_name}
Version: %{_ver}
Release: %{_rel}
License: See COPYING/COPYING.LIB file
Group: Applications/System
Source0: opfc-BidiBackend-1.0.2.tar.gz
Buildroot: %{_tmppath}/%{name}-root
Requires: libxml2 cups
Requires: %{opfc_prefix}libBidiformat >= 1.0.1
BuildRequires: libxml2-devel >= 2.5.11
BuildRequires: cups-devel
BuildRequires: %{opfc_prefix}libBidiPlugin-devel >= 1.0.0

%description
This packge is the part of "OpenPrinting Japan API Reference Implementation".
CUPS backend with Bidi status read support

%description -l ja_JP.utf8
このパッケージにはBidi-pluginをサポートしたCUPS用バックエンドが含まれています。
プリンタステータスモニタ TypeAを使用することでグラフィカルに情報を見る事ができます。

%package -n %{opfc_prefix}libBidiformat
Version:  1.0.1
Group: Development/Libraries
Summary: library for parse Printer-MIB information
Summary(ja_JP.utf8): Printer-MIB パースライブラリ
Requires: libxml2

%description -n %{opfc_prefix}libBidiformat
This package is the part of "OpenPrinting Japan API Reference Implementation".
Library for parse Printer-MIB format data.

%description -n %{opfc_prefix}libBidiformat -l ja_JP.utf8
このパッケージにはPrinter-MIB形式のXMLデータをパースするためのライブラリが含まれています。

%package -n %{opfc_prefix}libBidiformat-devel
Version:  1.0.1
Group: Development/Libraries
Summary: Development files for the libbidirformat
Summary(ja_JP.utf8): Printer-MIBパースライブラリ(開発用パッケージ)
Requires: %{opfc_prefix}libBidiformat = 1.0.1
BuildRequires: libxml2-devel >= 2.5.11
BuildRequires: cups-devel
Requires: %{opfc_prefix}libBidiPlugin-devel >= 1.0.0

%description -n %{opfc_prefix}libBidiformat-devel
This package is the part of "OpenPrinting Japan API Reference Implementation".
Development files for the %{name}

%description -n %{opfc_prefix}libBidiformat-devel -l ja_JP.utf8
このパッケージにはlibBidiformatを使用して開発するための開発用ライブラリが含まれています。

%prep
%setup -q -n opfc-BidiBackend-1.0.2

%build
CFLAGS="$RPM_OPT_FLAGS" \
%configure
make

%install
make install DESTDIR=${RPM_BUILD_ROOT}

%clean
rm -rf $RPM_BUILD_ROOT

%post -n %{opfc_prefix}libBidiformat -p /sbin/ldconfig
%postun -n %{opfc_prefix}libBidiformat -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc AUTHORS COPYING README README.jp ChangeLog
%{_libdir}/cups/backend/bidiusb
%{_libdir}/cups/backend/bidiparallel

%files -n %{opfc_prefix}libBidiformat
%defattr(-,root,root)
%doc COPYING.LIB
%{_libdir}/libbidiformat.so.*

%files -n %{opfc_prefix}libBidiformat-devel
%defattr(-,root,root)
%doc doc/bidibackend-1.0.1-apidoc.pdf
%doc Doxyheader Doxyfile
%{_includedir}/opfc/
%{_libdir}/libbidiformat.la
%{_libdir}/libbidiformat.so
%{_libdir}/libbidiformat.a
%{_libdir}/pkgconfig/bidiformat.pc

%changelog
* Wed Aug 18 2004 Toshihiro Yamagishi <toshihiro@turbolinux.co.jp>
- use XML_CPPFLAGS instead of XML_CFLAGS

* Thu Apr  8 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp> - 1.0.2
- fixed open flag in parallel backend. 
- [opfc:843] applied workaround patch for avoid communication block with parallel backend
	
* Wed Mar 31 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp>
- repackage for Turbolinux

* Fri Feb 20 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp> - 1.0.1
- fixed crash bug Do not free XMLinfo data in endBidiRead().
- cleand backend source code.

* Thu Feb 19 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp> - 1.0.0
- added getLang() function
- added comment	
	
* Wed Feb 18 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp> - 1.0.0beta5
- added getLang function
- cleanup test/ directory

* Mon Feb 17 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp> - 1.0.0beta4
- modified configure.in in order to link bidiPlugin.so correctly

* Mon Feb 16 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp> - 1.0.0beta3
- improved write data performance in writeData.c
- reading parameter of PPD file was changed to *opbidiPlugin:,*opbidiReadInterval:
- changed file names from bidiCommon.* to backendCommon.*
- delete LPGETSTATUS ioctl
	
* Fri Feb 13 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp> - 1.0.0beta2
- 1.0.0beta released
	
* Mon Feb 9 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp>
- 0.0.1beta released

