/*
 * Printer Status Utility Type A Program
 *
 * This program displays the printer status information the backend of
 * CUPS1.1 with OpenPrinting Bi-di plugin Type A capability has issued.
 *
 * Copyright (c) 2003, 2004
 *  E&D Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "psta_callbacks.h"
#include "psta_interface.h"
#include "psta_support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget *NameValue;
GtkWidget *StateValue;
GtkWidget *LocationValue;
GtkWidget *DescriptionValue;
GtkWidget *InkLevelTextView;
GtkWidget *WarningTextView;
GtkWidget *InkLevelFrame;

GtkWidget*
create_PrinterStatusUtilityTypeA (void)
{
  GtkWidget *PrinterStatusUtilityTypeA;
  GtkWidget *MainContainer;
  GtkWidget *MainVBox;
  GtkWidget *PrinterInfoFrame;
  GtkWidget *PrinterInfoContainer;
  GtkWidget *Name;
  GtkWidget *State;
  GtkWidget *Location;
  GtkWidget *Description;
  GtkWidget *PrinterInfoLabel;
  GtkWidget *InkLevelScrolledWindow;
  GtkWidget *InkLevelLabel;
  GtkWidget *WarningFrame;
  GtkWidget *WarningScrolledWindow;
  GtkWidget *WarningLabel;
  GtkWidget *ButtonContainer;
  GtkWidget *CloseButton;

  PrinterStatusUtilityTypeA = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (PrinterStatusUtilityTypeA, 316, 449);
  gtk_window_set_title (GTK_WINDOW (PrinterStatusUtilityTypeA), _("PrinterStatusUtilityTypeA"));
  gtk_window_set_resizable (GTK_WINDOW (PrinterStatusUtilityTypeA), FALSE);

  MainContainer = gtk_fixed_new ();
  gtk_widget_show (MainContainer);
  gtk_container_add (GTK_CONTAINER (PrinterStatusUtilityTypeA), MainContainer);

  MainVBox = gtk_vbox_new (FALSE, 8);
  gtk_widget_show (MainVBox);
  gtk_fixed_put (GTK_FIXED (MainContainer), MainVBox, 8, 8);
  gtk_widget_set_size_request (MainVBox, 300, 437);

  PrinterInfoFrame = gtk_frame_new (NULL);
  gtk_widget_show (PrinterInfoFrame);
  gtk_box_pack_start (GTK_BOX (MainVBox), PrinterInfoFrame, TRUE, TRUE, 0);
  gtk_widget_set_size_request (PrinterInfoFrame, 300, 70);

  PrinterInfoContainer = gtk_fixed_new ();
  gtk_widget_show (PrinterInfoContainer);
  gtk_container_add (GTK_CONTAINER (PrinterInfoFrame), PrinterInfoContainer);
  gtk_widget_set_size_request (PrinterInfoContainer, 300, 58);

  Name = gtk_label_new (_("Name :"));
  gtk_widget_show (Name);
  gtk_fixed_put (GTK_FIXED (PrinterInfoContainer), Name, 5, 2);
  gtk_widget_set_size_request (Name, 70, 17);
  gtk_label_set_justify (GTK_LABEL (Name), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (Name), 1, 0);

  State = gtk_label_new (_("State :"));
  gtk_widget_show (State);
  gtk_fixed_put (GTK_FIXED (PrinterInfoContainer), State, 5, 27);
  gtk_widget_set_size_request (State, 70, 17);
  gtk_label_set_justify (GTK_LABEL (State), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (State), 1, 0);

  Location = gtk_label_new (_("Location :"));
  gtk_widget_show (Location);
  gtk_fixed_put (GTK_FIXED (PrinterInfoContainer), Location, 5, 52);
  gtk_widget_set_size_request (Location, 70, 17);
  gtk_label_set_justify (GTK_LABEL (Location), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (Location), 1, 0);

  Description = gtk_label_new (_("Description :"));
  gtk_widget_show (Description);
  gtk_fixed_put (GTK_FIXED (PrinterInfoContainer), Description, 5, 77);
  gtk_widget_set_size_request (Description, 70, 17);
  gtk_label_set_justify (GTK_LABEL (Description), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (Description), 1, 0);

  NameValue = gtk_label_new ("");
  gtk_widget_show (NameValue);
  gtk_fixed_put (GTK_FIXED (PrinterInfoContainer), NameValue, 79, 2);
  gtk_widget_set_size_request (NameValue, 210, 17);
  gtk_label_set_justify (GTK_LABEL (NameValue), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (NameValue), 0, 0.5);

  StateValue = gtk_label_new ("");
  gtk_widget_show (StateValue);
  gtk_fixed_put (GTK_FIXED (PrinterInfoContainer), StateValue, 79, 27);
  gtk_widget_set_size_request (StateValue, 210, 16);
  gtk_label_set_justify (GTK_LABEL (StateValue), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (StateValue), 0, 0.5);

  LocationValue = gtk_label_new ("");
  gtk_widget_show (LocationValue);
  gtk_fixed_put (GTK_FIXED (PrinterInfoContainer), LocationValue, 79, 52);
  gtk_widget_set_size_request (LocationValue, 210, 17);
  gtk_label_set_justify (GTK_LABEL (LocationValue), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (LocationValue), 0, 0.5);

  DescriptionValue = gtk_label_new ("");
  gtk_widget_show (DescriptionValue);
  gtk_fixed_put (GTK_FIXED (PrinterInfoContainer), DescriptionValue, 79, 77);
  gtk_widget_set_size_request (DescriptionValue, 210, 17);
  gtk_label_set_justify (GTK_LABEL (DescriptionValue), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (DescriptionValue), 0, 0.5);

  PrinterInfoLabel = gtk_label_new (_("Printer"));
  gtk_widget_show (PrinterInfoLabel);
  gtk_frame_set_label_widget (GTK_FRAME (PrinterInfoFrame), PrinterInfoLabel);
  gtk_label_set_justify (GTK_LABEL (PrinterInfoLabel), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (PrinterInfoLabel), 0.2, 0);

  InkLevelFrame = gtk_frame_new (NULL);
  gtk_widget_show (InkLevelFrame);
  gtk_box_pack_start (GTK_BOX (MainVBox), InkLevelFrame, TRUE, TRUE, 0);
  gtk_widget_set_size_request (InkLevelFrame, 300, 80);

  InkLevelScrolledWindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (InkLevelScrolledWindow);
  gtk_container_add (GTK_CONTAINER (InkLevelFrame), InkLevelScrolledWindow);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (InkLevelScrolledWindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  InkLevelTextView = gtk_text_view_new ();
  gtk_widget_show (InkLevelTextView);
  gtk_container_add (GTK_CONTAINER (InkLevelScrolledWindow), InkLevelTextView);
  GTK_WIDGET_UNSET_FLAGS (InkLevelTextView, GTK_CAN_FOCUS);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (InkLevelTextView), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (InkLevelTextView), FALSE);

  InkLevelLabel = gtk_label_new (_("Ink Level"));
  gtk_widget_show (InkLevelLabel);
  gtk_frame_set_label_widget (GTK_FRAME (InkLevelFrame), InkLevelLabel);
  gtk_label_set_justify (GTK_LABEL (InkLevelLabel), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (InkLevelLabel), 0.2, 0);

  WarningFrame = gtk_frame_new (NULL);
  gtk_widget_show (WarningFrame);
  gtk_box_pack_start (GTK_BOX (MainVBox), WarningFrame, TRUE, TRUE, 0);
  gtk_widget_set_size_request (WarningFrame, 300, 90);

  WarningScrolledWindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (WarningScrolledWindow);
  gtk_container_add (GTK_CONTAINER (WarningFrame), WarningScrolledWindow);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (WarningScrolledWindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  WarningTextView = gtk_text_view_new ();
  gtk_widget_show (WarningTextView);
  gtk_container_add (GTK_CONTAINER (WarningScrolledWindow), WarningTextView);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (WarningTextView), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (WarningTextView), FALSE);

  WarningLabel = gtk_label_new (_("Warning"));
  gtk_widget_show (WarningLabel);
  gtk_frame_set_label_widget (GTK_FRAME (WarningFrame), WarningLabel);
  gtk_label_set_justify (GTK_LABEL (WarningLabel), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (WarningLabel), 0.2, 0);

  ButtonContainer = gtk_fixed_new ();
  gtk_widget_show (ButtonContainer);
  gtk_box_pack_start (GTK_BOX (MainVBox), ButtonContainer, FALSE, TRUE, 0);
  gtk_widget_set_size_request (ButtonContainer, 300, 32);

  CloseButton = gtk_button_new_with_mnemonic (_("Close"));
  gtk_widget_show (CloseButton);
  gtk_fixed_put (GTK_FIXED (ButtonContainer), CloseButton, 128, 3);
  gtk_widget_set_size_request (CloseButton, 48, 23);

  g_signal_connect ((gpointer) PrinterStatusUtilityTypeA, "destroy",
                    G_CALLBACK (on_window1_destroy),
                    NULL);
  g_signal_connect ((gpointer) CloseButton, "released",
                    G_CALLBACK (on_button1_released),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (PrinterStatusUtilityTypeA, PrinterStatusUtilityTypeA, "PrinterStatusUtilityTypeA");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, MainContainer, "MainContainer");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, MainVBox, "MainVBox");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, PrinterInfoFrame, "PrinterInfoFrame");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, PrinterInfoContainer, "PrinterInfoContainer");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, Name, "Name");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, State, "State");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, Location, "Location");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, Description, "Description");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, NameValue, "NameValue");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, StateValue, "StateValue");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, LocationValue, "LocationValue");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, DescriptionValue, "DescriptionValue");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, PrinterInfoLabel, "PrinterInfoLabel");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, InkLevelFrame, "InkLevelFrame");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, InkLevelScrolledWindow, "InkLevelScrolledWindow");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, InkLevelTextView, "InkLevelTextView");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, InkLevelLabel, "InkLevelLabel");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, WarningFrame, "WarningFrame");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, WarningScrolledWindow, "WarningScrolledWindow");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, WarningTextView, "WarningTextView");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, WarningLabel, "WarningLabel");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, ButtonContainer, "ButtonContainer");
  GLADE_HOOKUP_OBJECT (PrinterStatusUtilityTypeA, CloseButton, "CloseButton");

  return PrinterStatusUtilityTypeA;
}

