/** @file
 * @brief HTTP client
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#if !defined(httpc_h)
#define httpc_h

/* HTTP饤ȥơ */
#ifndef OK
#define OK (0)			/**< Complete status  */
#endif

#define SOCK_ERR (-1)		/**< Socket Level Communication Error */
#define HTTP_ERR (-2)		/**< HTTP Level Error  */
#define APP_ERR (-3)		/**< Application Level Error  */

/** HTTPǥեȥݡֹ
 */
#define DEFAULT_HTTP_PORT 80

/** HTTP饤ȥϥɥ
 *
 * ϥɥϡ1ͥˤĤ1ɬס
 */
typedef struct httpc_handle_ {
  
        int fd;			/**< descripter for socket */
        int timeout_sec;		/**< timeout for connect/read/write */
        const char *server_name;	/**< server name or ip addr */
        int code;			/**< HTTP status code */
        char *content_type;		/**< type of last content */
        char *location;		/**< location info */
        int content_length;		/**< Length of last content */
	
} httpc_handle;


/** HTTPФȤTCP/IPͥ򳫤
 *
 * \a server_name Ф \a port ֹ socket open롣
 * \a timeout_sec ǻꤵ줿ÿ³
 * \a handle ͤ¸֤롣
 *
 * ÿ³ʤäNULL֤
 *
 * \a handle httpcǳݤ롣³
 * #http_close() ƤӽФޤǤϥե꡼ͤѹƤϤʤ
 *
 * @param server_name ۥ̾⤷IPɥ쥹(dotɽ)
 * @param port ӥΥݡֹ
 * @param timeout_sec åȤΥॢȻ(sec)\n
 * 0ξ硢OSΥǥեȤεư˽
 *
 * @retval httpc_handle¤ΤؤΥݥ\n
 *		NULLξ硢顼(SOCK_ERR)Ǥ롣
 *
 * @note NULL(顼)֤äϡβ
 * ̿ѥåȤΥϽäƤ뤿ᡢ
 * #http_close()ƤӽФɬפ̵
 */
httpc_handle *http_open(const char *server_name,
			int port,
			int timeout_sec);


/** HTTPФǡ
 *
 * \a path ׵GETꥯȤȤƥФꡢ
 * \a handle  #timeout_sec λ \a response_entity 
 * 쥹ݥ󥹤Ǽ롣\a buff_size ۤ쥹ݥ󥹤ξ
 * \a buff_size ʬΥǡ \a response_entity ˳Ǽ
 * Ĥɤ߼ΤƤ #SOCK_ERR ֤
 *
 * ̿ǤǤ⥵Ф HTTP顼(200ʳ)֤Ƥ
 * \a response_entity إ顼쥹ݥ󥹤Ǽ #HTTP_ERR ֤
 * λ \a response_entity ȤϡHTTPλͤ
 * ¦HTTPФλ͡ưˤ˰¸뤿Ƥݾڤ줺
 * 顼ξ \a response_entity ɬ顼åȤϸ¤ʤ
 *
 * @note εǽϤޤǤ MozillaΤ褦 Web ֥饦ǥ쥹ݥ󥹤
 * ǧ褦ʥ桼ꤷƤεǽǤ
 *
 * \a handle  #content_type ˤϡ쥹ݥ󥹤֤ä content_type 
 * Ǽ֤
 *
 * @warning Apache error_code 200ʳξEntitychunk֤
 * μǤchunk򰷤ʤᡢApacheΥ顼Entityɤߤʤ
 *
 * @param handle HTTPc 桼ƥƥѥϥɥ
 * @param path ꥯȥޥ(0ߥ͡Ȥʸ)
 * @param response_entity ФǡγǼХåե
 * @param buff_size \a response_entity Хåե
 *
 * @retval OK ｪλ\nͤξ硢顼Ǥ롣\n
 * @retval APP_ERR \a response_entityΥĶEntity֤äƤ
 * @retval HTTP_ERR HTTPФ200ʳΥơ֤
 */
int http_get(httpc_handle *handle,
	     const char *path,
	     char *response_entity,
	     int buff_size);


/** HTTPФ˥ǡ
 *
 * FIXME: ̤б
 * ߡδؿƤФ \c ASSERT(0) 롣
 *
 * @param handle HTTPc 桼ƥƥѥϥɥ
 * @param path ꥯȥޥ(0ߥ͡Ȥʸ)
 * @param request_entity POST٤ǡäƤХåե
 * @param response_entity ФǡγǼХåե
 * @param buff_size \a response_entity Хåե
 *
 * @retval 0 ｪλ\nͤξ硢顼Ǥ롣\n
 */
int http_post(httpc_handle *handle,
	      const char *path,
	      const char *request_entity,
	      char *response_entity,
	      int buff_size);


/** HTTP 饤Ƚλ롣
 *
 * #http_open()ʹߡ#http_get()ʤɤǻѤꥢ
 * Socket ³ close롣
 * ܴؿ #http_open()硢Ʊ̿λݤɬ
 * ƤФʤƤϤʤʤ
 *
 * @param handle HTTPc 桼ƥƥѥϥɥ
 *
 * @retval 0 ｪλ\nͤξ硢顼Ǥ롣\n
 */
int http_close(httpc_handle *handle);


/** HTTP̿ΥॢȻ֤ꤹ
 * 
 * #http_get() , #http_post() ǤsocketФɤ߽񤭤
 * ॢȻ֤ꤹ롣
 * \a handle NULLꤷƤϤʤʤ( #http_open() ˤѤǤʤ)
 * äŪ #http_set_timeout() ƤӽФʤ硢 #http_open() ˻Ѥ
 * ॢȻ֤Ѥ롣
 *
 * @param handle httpc_handle¤ΤؤΥݥ
 * @param timeout_sec åȤΥॢȻ(sec)
 * @retval OK ｪλ
 */
int http_set_timeout(httpc_handle *handle, int timeout_sec);


/** Ǹ˼ƥĤContent-Type
 *
 * httpc_handle¤˳ǼƤNULLߥ͡Ȥ줿
 * Content-Typeʸ֤
 * http_close()ƤӽФ뤫http_get()/http_post()
 * ¹ԤޤǡContent-Typeΰݾ㤵롣
 * 
 * @param handle http_open()˼httpc_handle¤ΤؤΥݥ
 * @retval Content-Typeʸ󤬳Ǽ줿ΰƬɥ쥹 \n
 * ľhttp_get(), http_post()Ԥͤݾ㤵ʤ\n
 * 쥹ݥContent-TypeإåޤޤƤʤä硢NULL֤
 */
char *http_get_content_type(httpc_handle *handle);


/** Ǹ˼ƥĤLocation
 *
 * httpc_handle¤˳ǼƤNULLߥ͡Ȥ줿
 * Locationإåʸ֤
 * http_close()ƤӽФ뤫http_get()/http_post()
 * ¹ԤޤǡContent-Typeΰݾ㤵롣
 * 
 * @param handle http_open()˼httpc_handle¤ΤؤΥݥ
 * @retval Locationإåʸ󤬳Ǽ줿ΰƬɥ쥹 \n
 * ľhttp_get(), http_post()Ԥͤݾ㤵ʤ
 * 쥹ݥLocationإåޤޤƤʤä硢NULL֤
 */
char *http_get_location(httpc_handle *handle);


/** Ǹ˼ƥĤContent-Length
 *
 * httpc_handle¤˳ǼƤContent-LengthֵѤ롣
 *
 * @param handle http_open()˼httpc_handle¤ΤؤΥݥ
 *
 * @retval ƥĤĹ\n
 * ľhttp_get(), http_post()Ԥͤݾ㤵ʤ
 */
int http_get_content_length(httpc_handle *handle);


/** Ǹ˹ԤʤäHTTP̿ǥФ֤ơɤ
 *
 * httpc_handle¤˳ǼƤHTTP Status CodeֵѤ롣
 *
 * @param handle http_open()˼httpc_handle¤ΤؤΥݥ
 *
 * @retval HTTP륹ơ \n
 * ľhttp_get(), http_post()Ԥͤݾ㤵ʤ
 */
int http_get_status_code(httpc_handle *handle);


/** URL󥳡ɤԤ
 *
 * ХʥǡϤȤƼꡢ󥳡ɤ줿ǡϤ롣
 * ͤϽʸĹͤϽԡ
 * outNULLꤵ줿ϡХåեؤν񤭽ФԤ鷺
 * ϥǡĹΤ֤
 * ϥǡnullߥ͡Ȥʤ
 *
 * note: \n
 * URL󥳡ɤԤȤǡǰΥϥǡϥǡ3ܤΥˤʤ롣
 * in_len * 3outݤСϤƥ顼֤뤳ȤϤʤ
 *
 * @param in ϥǡ
 * @param in_len ϥǡĹ
 * @param out ǡꥢ\n
 *			  NULLˤȥǡνϤϹԤʤ
 * @param out_len ǡꥢĹ
 * @return ϥǡĹͤξ票顼(ϥǡꥢ­Ƥ)
 *		   out = NULLξϾ롣
 */
int url_encode(const char *in, int in_len, char* out, int out_len);


/** URL󥳡ɤ줿ʸǥɤ
 *
 * 󥳡ɤ줿ǡϤȤƼꡢХʥǡϤ롣
 * ͤϽʸĹͤϽԡ
 * outNULLꤵ줿ϡХåեؤν񤭽ФԤ鷺
 * ϥǡĹΤ֤
 * ϥǡnullߥ͡Ȥʤ
 *
 * note: \n
 * URLǥɤǤϡϤƱνϥꥢѰդС
 * Ϥƥ顼֤뤳ȤϤʤ
 *
 * @param in ϥǡ
 * @param in_len ϥǡĹ
 * @param out ǡꥢ\n
 *			  NULLˤȥǡνϤϹԤʤ
 * @param out_len ǡꥢĹ
 * @return ϥǡĹͤξ票顼(ϥǡꥢ­Ƥ)
 *		   out = NULLξϾ롣
 */
int url_decode(const char *in, int in_len, char* out, int out_len);
		
#endif /* !defined(httpc_h) */
