/** @file
 * @brief Printer daemon I/O function(s).
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include "psub_common.h"
#include "psub_debug.h"
#include "psub_daemonio.h"



LOCAL_FUNC void
del_CRLF(char *s)
{
        int n = strlen(s);

        if ( 0 == n )
                return;

        for ( n-- ; n != 0 && ( 0x0d == s[n] || 0x0a == s[n] ) ; n-- )
                s[n] = '\0';
}


LOCAL_FUNC const char *
skip_wsp( const char *str )
{
        /* Skip Word Space */
        while ( ' ' == *str || '\t' == *str )
                str++;

        return str;
}


FUNCTION int
get_pr_list( const char *str, char **plist, char **comment )
{
        int num = 0;

        while ( *str != '\0' )
        {
                int i = 0;
                char name[MAX_PRINTER_NAME];
                char description[MAX_COMMENT_SIZE];
                char *p = name;

                str = skip_wsp(str);

                /* Get Printer name */
                for ( i = 0; ' '  != *str && '\t' != *str &&
                              '\0' != *str && '\n' != *str ; i++ )
                {
                        if ( i < MAX_PRINTER_NAME )
                                p[i] = *str;
                        str++;
                }

                if ( i < MAX_PRINTER_NAME )
                        p[i] = '\0';
                else
                        p[(MAX_PRINTER_NAME -1)] = '\0';

                str = skip_wsp(str);

                /* Set comment */
                {
                        int j;
                        p = description;
                        for ( j = 0; '\0' != *str && '\n' != *str; j++ ) {
                                if ( j < MAX_COMMENT_SIZE )
                                        p[j] = *str;
                                str++;
                        }
                        if ( j < MAX_COMMENT_SIZE )
                                p[j] = '\0';
                        else
                                p[(MAX_COMMENT_SIZE -1)] = '\0';
                }

                /* Copy printer name to buffer */
                if ( 0 != i )
                {
                        if( num < MAX_PRINTER_LIST ) {
                                strcpy( plist[num], name );
                                del_CRLF(plist[num]);
                                strcpy( comment[num], description );
                                del_CRLF(comment[num]);
                        }
                        num++;
                }

                if ( '\0' != *str )
                        str++;
        }
        return num;
}



/* End of file */
