/** @file
 * @brief Process type BiDi-module data(XML) handling utility.
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @note libxml¸򤱤뤿ᡢܥإåΥ󥯥롼ˤ
 * libxml.h򥤥󥯥롼ɤʤƤȤ褦˥åԥ󥰤롣
 *
 *   Calling sequence (example)
 *
 *     \# char *response  XMLTEXT data
 *
 *     char str[DISP_BUFF_SIZE];\n
 *     void *doc;
 *
 *     doc = xml_start(response, sizeof(response));\n
 *     		.....
 *
 *     get_printer_status(doc, str, sizeof(str));\n
 *     		.....
 *
 *     get_supplies_status(doc, str, sizeof(str));\n
 *     		.....
 *
 *     get_printer_alert(doc, str, sizeof(str));\n
 *     		.....
 *
 *     xml_end(doc);
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef PSUB_XMLUTIL_H
#define PSUB_XMLUTIL_H

/** XMLβϽγ
 *
 * BiDi֤XMLǡlibxmlǰѴ롣
 *
 * @param buf  XMLTEXT data
 * @param size  \a buf Υ
 *
 * @retval xmlDocPtr
 *	˽λxmlDocPtr \c void *Ѵ֤
 *	顼ä \c NULL ֤
 *
 * @note
 * ͤ \c void *ϡ\c malloc() ˤäƳݤƤ뤿
 *  \c free() ɬפ롣\nνϡ#xml_end() ǹԤ
 */
FUNCTION void *xml_start( const char *buf, int size );

/** XMLβϽνλ
 *
 * #xml_start() ǤνФ뽪λ
 *
 * @param doc xmlDocPtr
 *
 * @note δؿʹ \a doc ̵ˤʤ뤿ᡢѤƤϤʤ
 */
FUNCTION void xml_end( const void *doc );

/** ץ󥿥ơμ
 * @param doc       xmlDocPtr
 * @param buf       ɽѥåǼѥХåե
 * @param buf_size  \a buf Υ
 * @retval 0 OK
 * @retval -1 ERROR
 *	λ \a buf ʸξ֤ݾڤʤ
 */
FUNCTION int get_printer_status(void *doc, char *buf, int buf_size);

/** ʾμ
 *
 * XMLʾåȴФ
 * ｪλݤbufˤϡDEFAULT_LANG(UTF-8)
 * 󥳡ǥ󥰤줿BiDiΥå
 * ĤǤˤĤ'\n'ǥѥ졼ȤԤ
 * ʣ(԰ʾ)Ǽ롣
 * bufʸνüˣĤNUL('\\0')񤭹֤
 *
 * Example
 *	char * buf = malloc(BUFF_SIZE);\n
 *	get_supplies_status(doc, buf, BUFF_SIZE);\n
 *	printf("%s",buf);\n
 *\n
 *	result:\n
 *		 80%\n
 *		ޥ 75%\n
 *		 60%\n
 *		֥å 50%\n
 *
 * @param doc      xmlDocPtr
 * @param buf      ɽѥåǼѥХåե
 * @param buf_size \a buf Υ
 * @retval 0 OK
 * @retval -1 ERROR\n
 *	λ \a buf ʸξ֤ݾڤʤ
 *
 */
FUNCTION int get_supplies_status(void *doc, char *buf, int buf_size);

/** ٹʥץ󥿤ξ֡˾μ
 *
 *	XMLٹåȴФ
 *	ｪλݤbufˤϡDEFAULT_LANG(UTF-8)
 *	󥳡ǥ󥰤줿BiDiΥå
 *	ĤǤˤĤ'\n'ǥѥ졼ȤԤ
 *	ʣ(԰ʾ)Ǽ롣
 *	bufʸνüˣĤNUL('\\0')񤭹֤\n
 *\n
 * Example\n
 *	char * buf = malloc(BUFF_SIZE);\n
 *	get_printer_alert(doc, buf, BUFF_SIZE);\n
 *	printf("%s",buf);\n
 *\n
 *	result:\n
 *		󤬾ʤʤäƤޤ\n
 *		ޥʤʤäƤޤ\n
 *		ʤʤäƤޤ\n
 *
 * @param doc       xmlDocPtr
 * @param buf       ɽѥåǼѥХåե
 * @param buf_size  \a buf Υ
 * @retval 0 OK
 * @retval -1 ERROR\n
 *	λ \a buf ʸξ֤ݾڤʤ
 */
FUNCTION int get_printer_alert(void *doc, char *buf, int buf_size);

#endif /* PSUB_XMLUTIL_H */

/* End of file */
