# -*- coding:utf-8-unix -*-
#
# Copyright (c) 2000-2003 Turbolinux, inc. 
# This file and all modifications and/or additions are under 
# the same license as package itself.

%define _name opfc-StatusMonitor
%define _ver  1.0.0
%define _rel  1
%define opfc_prefix opfc-

Summary: OpenPrinting Japan - Printer Status utility
Summary(ja_JP.utf8): プリンタステータスモニタ
Name: %{_name}
Version: %{_ver}
Release: %{_rel}
License: See COPYING file
Group: Applications/System
Source0: opfc-StatusMonitor-1.0.0.tar.gz
Buildroot: %{_tmppath}/%{name}-root
BuildRequires: gtk2-devel atk-devel expat-devel cups-devel pkgconfig libxml2-devel

%description
This package is the part of "OpenPrinting Japan API Reference Implementation".
Printer Status utility. Included are:
 opfc-StatusMonitor-A (Printer status utility type A.Fetch status from CUPS backend.)
 opfc-StatusMonitor-B (Printer status utility type B.Fetch status from PrinterStatus daemon.)

%package A
Version: 0.5
License: See COPYING file
Group: Applications/System
Summary: OpenPrinting Japan - Printer Status Utility TypeA
Summary(ja_JP.utf8): プリンタステータスモニタ TypeA
Requires: gtk2 cups
Requires: %{opfc_prefix}BidiBackend

%description A
Printer Status Utility sample implementation TypeA

%description A -l ja_JP.utf8
このパッケージにはCUPSからプリンタ情報を取得して表示するステータスモニタが含まれています。
Bidi APIをサポートしたCUPS用バックエンドが必要です。

%package B
Version: 0.2
License: See COPYING
Group: Applications/System
Summary: OpenPrinting Japan - Printer Status Utility TypeB
Summary(ja_JP.utf8): プリンタステータスモニタ TypeB
Requires: gtk2
Requires: %{opfc_prefix}StatusDaemon

%description B
Printer Status Utility sample implementation TypeB

%description B -l ja_JP.utf8
このパッケージにはStatusDaemonからプリンタ情報を取得して表示するステータスモニタが含まれています。
StatusDaemonパッケージが必要です。

%prep
%setup -q -n opfc-StatusMonitor-1.0.0

%build
CFLAGS="$RPM_OPT_FLAGS" \
%configure
make

%install
make install DESTDIR=${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/%{_initrddir}

%clean
rm -rf $RPM_BUILD_ROOT

%files A
%defattr(-,root,root)
%doc TypeA/AUTHORS TypeA/COPYING TypeA/README TypeA/ChangeLog
%{_bindir}/printerStatusTypeA
#%{_datadir}/locale/*/LC_MESSAGES/printerStatusTypeA.*

%files B
%defattr(-,root,root)
%doc TypeB/AUTHORS TypeB/COPYING TypeB/README TypeB/ChangeLog
%{_bindir}/printerStatusTypeB
%{_datadir}/locale/*/LC_MESSAGES/printerStatusTypeB.*

%changelog
* Wed Mar 31 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp>
- repackage for Turbolinux
