# -*- coding:utf-8-unix -*-
#
# Copyright (c) Turbolinux, Inc.
# This file and all modifications and/or additions are under 
# the same license as package itself.

%define _name opfc-libBidiPlugin
%define _ver  1.0.0
%define _rel  1

Summary: OpenPrinting Japan - Bidi plguin library
Summary(ja_JP.utf8): Bidiプラグインライブラリ
Name: %{_name}
Version: %{_ver}
Release: %{_rel}
License: See COPYING file
Group: Applications/System
SOURCE: opfc-libBidiPlugin-1.0.0.tar.gz
Buildroot: %{_tmppath}/%{name}-root

%description
A library for bi-directional communication between
your software and printer hardware,reusable code
for plugin writers and vendor directories with plugins.
This packge is the part of OpenPrinting Japan API
reference implementation project.

%description -l ja_JP.utf8
このパッケージにはプラグインに対応したBidi APIライブラリが含まれています。
このライブラリと各プリンタのプラグインモジュールを利用する事でプリンタからステータス情報を取得する事ができます。

%package devel
Group: Development/Libraries
Summary: Development files for the %{name}
Summary(ja_JP.utf8): Bidiプラグインライブラリ(開発用パッケージ)
Requires: %{name} = %{version}
Requires: pkgconfig

%description devel
Development librarie and header files for the %{name}

%description devel -l ja_JP.utf8
このパッケージにはopfc-libBidiPluginを使用してプラグインを開発するための開発用ライブラリが含まれています。
 
%prep
%setup -q -n opfc-libBidiPlugin-1.0.0

%build
CFLAGS="$RPM_OPT_FLAGS" \
%configure
make

%install
make install DESTDIR=${RPM_BUILD_ROOT}

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc COPYING README ChangeLog
%{_libdir}/libbidiplugin.so.*

%files devel
%defattr(-,root,root)
%doc doc/Bi-diPlug-in_CallerAPI.pdf
%{_includedir}/opfc/
%{_libdir}/libbidiplugin.la
%{_libdir}/libbidiplugin.a
%{_libdir}/libbidiplugin.so
%{_libdir}/pkgconfig/libBidiPlugin.pc
%{_datadir}/aclocal/libBidiPlugin.m4

%changelog
* Wed Mar 31 2004 Toshihiro Yamagishi<toshihiro@turbolinux.co.jp>
- repackage for Turbolinux

