class PosWin
  def initialize(keydecoder, conf)
    @keydecoder = keydecoder
    @sock = @keydecoder.register.sock
    @window = Gtk::Window::new(Gtk::WINDOW_TOPLEVEL)
    @window.set_title("#{POS_TITLE} Ver.#{POS_VERSION}")
    @window.border_width(0)
    @window.set_default_size(700, 500)
    vbox = Gtk::VBox.new
    vbox.show
    @dbh = @keydecoder.register.dbh
    accel = Gtk::AccelGroup.new
    accel.attach @window
    callback = Proc.new do |i| print "#{i} is activated.\n" end
    new_item_proc    = Proc.new do |i| NewItemDialog.new(i)  end
    search_item_proc = Proc.new do |dbh| SearchItemWin.new(@dbh, @sock) end
    config_proc      = Proc.new do |i| ConfigDialog.new(conf)  end
    restart = Proc.new{ if(fork) then exec"./opossum" else exit end}
    quit = Proc.new{ Gtk.main_quit }
#    ifp = Gtk::ItemFactory.new(Gtk::ItemFactory::TYPE_MENUBAR, "<main>", accel)
    ifp  = Gtk::ItemFactory.new(Gtk::ItemFactory::TYPE_MENU_BAR, "<main>", accel)
    ifp.create_items(
    [["/ե(_F)",              nil,          Gtk::ItemFactory::BRANCH,   nil,      nil],
#     ["/ե(_F)/Tearoff1",     nil,          Gtk::ItemFactory::TEAROFF,  nil,      nil],
#     ["/ե(_F)/(_N)", "<control>N", Gtk::ItemFactory::ITEM,     callback, nil],
#     ["/ե(_F)/(_O)",     "<control>O", nil,                        callback, nil],
#     ["/ե(_F)/ѥ졼",   nil,          Gtk::ItemFactory::SEPARATOR,nil,      nil],
     ["/ե(_F)/Ƶư",     nil,          nil,                        restart,     nil],
     ["/ե(_F)/λ(_Q)",     "<control>Q", nil,                        quit,     nil],
     ["/Խ(_E)",                  nil,          Gtk::ItemFactory::BRANCH,   nil,      nil],
     ["/Խ(_E)/(_N)",     nil,          Gtk::ItemFactory::ITEM,     new_item_proc, @keydecoder],
     ["/Խ(_E)/Խ(_E)",     nil,          Gtk::ItemFactory::ITEM,  search_item_proc, @dbh],
     ["/Խ(_E)/(_O)",     nil,          Gtk::ItemFactory::ITEM,  config_proc, @keydecoder],
     ["/إ(_H)",                nil,      Gtk::ItemFactory::LAST_BRANCH,  nil,      nil],
     ["/إ(_H)/_About",         nil,          nil,                       nil,       nil]])
    mbar = ifp.get_widget("<main>")
    mbar.show
    vbox.pack_start mbar, false, false, 0

    @table = Gtk::Table.new(3, 3, false)
    @table.border_width = 10
    
    @scrolled_win = Gtk::ScrolledWindow.new()
    @scrolled_win.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_ALWAYS)
    
    @scrolled_win.show
    @window.add vbox
    vbox.pack_start @scrolled_win, true, true, 0
    
    hbox  = Gtk::HBox.new
    hbox.show
    frame = Gtk::Frame.new("å")
    frame.show
    
    message_label = Gtk::Label.new(
	 "СɥʤǾʥСɤɤ߼äƤ\n" +
	 "ˤϥڡ򲡤Ƥ\n"+
	 "ʣʤϤˤ  򲡤Ƥ")
    message_label.show
    message_label.set_alignment(0, 0)
    message_label.jtype = Gtk::JUSTIFY_LEFT
    message_label.set_padding(10, 0)
    frame.border_width = 10
    frame.add message_label
    hbox.pack_start @table, false, false, 0
    hbox.pack_start frame, false, false, 0
    vbox.pack_start hbox, false, false, 0
    # @table.attach(@scrolled_win, 0, 3, 0, 1, nil, nil, 5, 5)
    
    @item_list = Gtk::CList::new(["̾", "ñ", "Ŀ", ""])
#    @item_list.set_style(style)
    @item_list.set_column_justification(1, Gtk::JUSTIFY_RIGHT)
    @item_list.set_column_justification(2, Gtk::JUSTIFY_RIGHT)
    @item_list.set_column_justification(3, Gtk::JUSTIFY_RIGHT)

    # item_list.set_usize(0, 300)
    @item_list.set_column_width(0, 400)
    @item_list.set_column_width(1, 60)
    @item_list.set_column_width(2, 60)
    @item_list.set_column_width(3, 60)
    @item_list.set_selection_mode(Gtk::SELECTION_MULTIPLE)
    @item_list.set_selection_mode(Gtk::SELECTION_BROWSE)
    @item_list.show
    
    @window.signal_connect("key_press_event") do |w,e|
      @keydecoder.get_char(self, e)
    end
    
    @scrolled_win.add(@item_list)
    
    # ---------------------------------------------------
    #  
    # ---------------------------------------------------
    @sum_label = Gtk::Label.new("ס")
    @sum_label.set_alignment(1,0.5)
    @sum_label.show
#    @sum_label.jtype = Gtk::JUSTIFY_RIGHT
#    @sum_label.right_justify
    @sum_yen = Gtk::Label.new("")
    @sum_yen.show
    @sum_ent = Gtk::Entry.new
    @sum_ent.show
    @sum_ent.set_editable(false)
    
    # ---------------------------------------------------
    #  ¤
    # ---------------------------------------------------
    
    @depo_label = Gtk::Label.new("¤ꡧ")
    @depo_label.set_alignment(1,0.5)
    @depo_label.show
    @depo_yen = Gtk::Label.new("")
    @depo_yen.set_justify(Gtk::JUSTIFY_LEFT)
    @depo_yen.show
    @depo_ent = Gtk::Entry.new
    @depo_ent.show
    @depo_ent.set_editable(false)
    
    # ---------------------------------------------------
    #  
    # ---------------------------------------------------
    @change_label = Gtk::Label.new("ꡧ")
    @change_label.set_alignment(1,0.5)    
    @change_label.show
    @change_yen = Gtk::Label.new("")
    @change_yen.set_justify(Gtk::JUSTIFY_LEFT)
    @change_yen.show
    @change_ent = Gtk::Entry.new
    @change_ent.show
    @change_ent.set_editable(false)
    
    
    @table.attach(@sum_label   , 0, 1, 0, 1, 4, 4)

    @table.attach(@sum_ent     , 1, 2, 0, 1, 4, 4)
    @table.attach(@sum_yen     , 2, 3, 0, 1, 4, 4)
    
    @table.attach(@depo_label  , 0, 1, 1, 2, 4, 4)
    @table.attach(@depo_ent    , 1, 2, 1, 2, 4, 4)
    @table.attach(@depo_yen    , 2, 3, 1, 2, 4, 4)
    
    @table.attach(@change_label, 0, 1, 2, 3, 4, 4)
    @table.attach(@change_ent  , 1, 2, 2, 3, 4, 4)
    @table.attach(@change_yen  , 2, 3, 2, 3, 4, 4)
    @table.set_row_spacings(5)
    @table.set_col_spacings(5)
#    @window.add @table
    @table.show
    @window.show
  end
  def start
    Gtk::main()
  end
  def add_row(item = 'ʤ', price = 0, number = 0, subtotal = 0)
    @item_list.append([item, price.to_s, number.to_s, subtotal.to_s])
    @scrolled_win.vadjustment.set_value(@scrolled_win.vadjustment.upper)
    @item_list.hide
    @item_list.show_now
  end
  def update_last(item_name, price, number, subtotal)

=begin    
    item_name = @item_list.get_text(0, @item_list.rows -1)
    price     = @item_list.get_text(1, @item_list.rows -1)
    number    = @item_list.get_text(2, @item_list.rows -1)
    subtotal  = @item_list.get_text(3, @item_list.rows -1)
=end

#    puts [item_name, price, number, subtotal]
    @item_list.remove_row(@item_list.rows - 1)
    @item_list.append([item_name, price.to_s, number.to_s, subtotal.to_s])
    @scrolled_win.vadjustment.set_value(@scrolled_win.vadjustment.upper)
    @item_list.hide
    @item_list.show_now
  end
  def update_sum(sum)
    @sum_ent.set_text(sum.to_s)
  end
  def update_depo(deposit)
    @depo_ent.set_text(deposit.to_s)
    change = deposit.to_i - @sum_ent.get_text.to_i
    @change_ent.set_text(change.to_s)
  end
  def clear_all
    @item_list.clear
    @sum_ent.set_text('')
    @depo_ent.set_text('')
    @change_ent.set_text('')
  end
end
