/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

/**
 * ローソク足情報生成設定情報の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum CandlestickGeneratorSettingType {

	/**
	 * 胴体が長い
	 */
	LONG_BODY,

	/**
	 * 胴体が同時
	 */
	DOJI,

	/**
	 * 影(ヒゲ)が長い
	 */
	LONG_SHADOW,

	/**
	 * 影(ヒゲ)が無い(極短含む)
	 */
	NO_SHADOW,

	/**
	 * 同距離
	 */
	SAME,

	/**
	 * 近距離
	 */
	NEAR,

	/**
	 * 遠距離
	 */
	FAR;

}
