/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

import java.util.List;

import jp.sourceforge.orangesignal.ta.candle.TrendType;
import jp.sourceforge.orangesignal.ta.result.Step;


/**
 * 新値足データからトレンド情報を処理するトレンドプロセッサークラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public final class ShinneTrendProcessor extends StepTrendProcessor {

	/**
	 * コンストラクタです。
	 * 
	 * @param shinne 新値足データ
	 */
	public ShinneTrendProcessor(final List<Step> shinne) {
		super(shinne);
	}

	@Override
	protected TrendType getTrend(final Step shinne) {
		if (shinne.open < shinne.high)
			return TrendType.UP;
		return TrendType.DOWN;
	}

}
