/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

/**
 * トレンドプロセッサーがトレンド情報の付与に失敗した場合にスローする例外クラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public class TrendProcessorException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public TrendProcessorException() {
		super();
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 */
	public TrendProcessorException(final String message) {
		super(message);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param message 詳細なエラーメッセージ
	 * @param cause 原因
	 */
	public TrendProcessorException(final String message, final Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param cause 原因
	 */
	public TrendProcessorException(final Throwable cause) {
		super(cause);
	}

}
