/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.backtest;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.SimpleBindings;
import jp.sourceforge.orangesignal.ta.dataset.StandardDataset;
import jp.sourceforge.orangesignal.ta.dataset.TimeSeriesDataset;
import jp.sourceforge.orangesignal.ta.dataset.loader.DatasetLoader;
import jp.sourceforge.orangesignal.trading.VirtualTrader;
import jp.sourceforge.orangesignal.trading.backtest.BacktesterEvent;
import jp.sourceforge.orangesignal.trading.backtest.BacktesterListener;
import jp.sourceforge.orangesignal.trading.order.OrderTiming;
import jp.sourceforge.orangesignal.trading.stats.Stats;
import jp.sourceforge.orangesignal.trading.stats.Summary;
import jp.sourceforge.orangesignal.trading.strategy.Strategy;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;

public class Backtester {
    private DatasetLoader datasetLoader;
    private Date startDate;
    private Date endDate;
    private Map<String, String> symbols;
    private List<Strategy> strategies;
    private VirtualTrader trader;
    private OrderTiming defaultOrderTiming = OrderTiming.NEXT_OPEN;
    private List<BacktesterListener> listeners = new ArrayList<BacktesterListener>(1);

    public DatasetLoader getDatasetLoader() {
        return this.datasetLoader;
    }

    public void setDatasetLoader(DatasetLoader datasetLoader) {
        this.datasetLoader = datasetLoader;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(Map<String, String> symbolMap) {
        this.symbols = symbolMap;
    }

    public List<Strategy> getStrategies() {
        return this.strategies;
    }

    public void setStrategies(List<Strategy> strategies) {
        this.strategies = strategies;
    }

    public VirtualTrader getTrader() {
        return this.trader;
    }

    public void setTrader(VirtualTrader trader) {
        this.trader = trader;
    }

    public OrderTiming getDefaultOrderTiming() {
        return this.defaultOrderTiming;
    }

    public void setDefaultOrderTiming(OrderTiming defaultOrderTiming) {
        this.defaultOrderTiming = defaultOrderTiming;
    }

    public void addBacktesterListener(BacktesterListener listener) {
        this.listeners.add(listener);
    }

    public void removeBacktesterListener(BacktesterListener listener) {
        this.listeners.remove(listener);
    }

    public double getInitialCapital() {
        return this.trader.getInitialCapital();
    }

    public Summary backtest() {
        int max = this.symbols.size();
        int count = 0;
        LinkedHashMap<String, Stats> statsMap = new LinkedHashMap<String, Stats>(max + 1, 1.0f);
        for (Map.Entry<String, String> entry : this.symbols.entrySet()) {
            String symbol = entry.getKey();
            this.datasetLoader.setSymbol(symbol);
            StandardDataset dataset = new StandardDataset(this.datasetLoader.load());
            dataset.setSymbolName(entry.getValue());
            HashMap<String, StandardDataset> datasetMap = new HashMap<String, StandardDataset>(2, 1.0f);
            datasetMap.put(symbol, dataset);
            this.trader.setDatasetMap(datasetMap);
            BacktesterEvent event = new BacktesterEvent(this, max, ++count, symbol, dataset.getSymbolName(), null);
            for (BacktesterListener listener : this.listeners) {
                listener.backtestStart(event);
            }
            this.trader.reset();
            if (this.strategies == null) continue;
            int start = dataset.defaultIndexOf(this.startDate);
            int end = dataset.defaultLastIndexOf(this.endDate);
            SimpleBindings context = new SimpleBindings();
            for (Strategy strategy : this.strategies) {
                strategy.setTrader(this.trader);
                strategy.setDefaultOrderTiming(this.defaultOrderTiming);
                strategy.setSymbol(symbol);
                strategy.setDataset(dataset);
                strategy.setStartDataIndex(start);
                strategy.setEndDataIndex(end);
                strategy.init();
            }
            Date[] date = dataset.getDate();
            block3: for (int i = start; i <= end; ++i) {
                for (Strategy strategy : this.strategies) {
                    strategy.setCurrentDataIndex(i);
                    strategy.setDate(date[i]);
                    StrategyStatus status = strategy.process();
                    if (status == null || status != StrategyStatus.FILTER) continue;
                    continue block3;
                }
            }
            for (Strategy strategy : this.strategies) {
                strategy.terminate();
                strategy.setDataset(null);
                strategy.setSymbol(null);
                strategy.setDefaultOrderTiming(null);
                strategy.setTrader(null);
            }
            context.clear();
            Stats stats = new Stats(this.trader.getPositions(), this.trader.getInitialCapital(), (TimeSeriesDataset)dataset, start, end);
            statsMap.put(symbol, stats);
            event = new BacktesterEvent(this, max, count, symbol, dataset.getSymbolName(), stats);
            for (BacktesterListener listener : this.listeners) {
                listener.backtestProcessed(event);
            }
        }
        return new Summary(statsMap, this);
    }
}

