/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.order;

import java.io.Serializable;
import java.util.Date;
import jp.sourceforge.orangesignal.trading.order.Order;

abstract class AbstractOrder
implements Order,
Serializable {
    private static final long serialVersionUID = -833003275626738986L;
    private String symbol;
    private String label;
    private Date date;
    private int quantity;
    private Integer findId;
    private String findLabel;

    protected AbstractOrder() {
    }

    protected AbstractOrder(String symbol, String label, Date date, int quantity, Integer findId, String findLabel) {
        if (date == null) {
            throw new NullPointerException();
        }
        this.symbol = symbol;
        this.label = label;
        this.date = date;
        this.quantity = quantity;
        this.findId = findId;
        this.findLabel = findLabel;
    }

    @Override
    public String getSymbol() {
        return this.symbol == null ? "" : this.symbol;
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final Date getDate() {
        return this.date;
    }

    @Override
    public final int getQuantity() {
        return this.quantity;
    }

    @Override
    public Integer getFindId() {
        return this.findId;
    }

    public void setFindId(Integer findId) {
        this.findId = findId;
    }

    @Override
    public String getFindLabel() {
        return this.findLabel;
    }

    public void setFindLabel(String findLabel) {
        this.findLabel = findLabel;
    }

    @Override
    public final int compareTo(Order o) {
        return this.date.compareTo(o.getDate());
    }
}

