/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.stats.report;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.SimpleBindings;
import jp.sourceforge.orangesignal.trading.backtest.Backtester;
import jp.sourceforge.orangesignal.trading.stats.Stats;
import jp.sourceforge.orangesignal.trading.stats.Summary;
import jp.sourceforge.orangesignal.trading.stats.report.Reporter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextFileReporter
implements Reporter {
    protected static final Log log = LogFactory.getLog(TextFileReporter.class);
    protected static final String DEFAULT_BASE_PATH = "/template/xhtml/";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static Configuration defaultConfig = new Configuration();
    protected static final Map<String, String> defaultSummaryTemplateMap;
    protected static final Map<String, String> defaultStatsTemplateMap;
    protected static final List<String> defaultResourceList;
    protected Configuration freemarker = defaultConfig;
    protected Map<String, String> summaryTemplateMap = defaultSummaryTemplateMap;
    protected Map<String, String> statsTemplateMap = defaultStatsTemplateMap;
    protected List<String> resourceList = defaultResourceList;
    protected String dir = ".";
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_BACKTESTER = "backtester";
    public static final String KEY_SUMMARY = "summary";
    public static final String KEY_WIN_SUMMARY = "win";
    public static final String KEY_LOSS_SUMMARY = "loss";
    public static final String KEY_STATS_MAP = "stats";
    public static final String KEY_SYMBOL = "symbol";
    public static final String KEY_SYMBOL_NAME = "symbolName";
    public static final String KEY_STATS = "stats";
    public static final String KEY_LONG_STATS = "long";
    public static final String KEY_SHORT_STATS = "short";
    public static final String KEY_WIN_STATS = "win";
    public static final String KEY_LOSS_STATS = "loss";
    public static final String KEY_TRADE_LIST = "trade_list";

    public void setFreemarker(Configuration freemarker) {
        this.freemarker = freemarker;
    }

    public void setSummaryTemplateMap(Map<String, String> summaryTemplateMap) {
        this.summaryTemplateMap = summaryTemplateMap;
    }

    public void setStatsTemplateMap(Map<String, String> statsTemplateMap) {
        this.statsTemplateMap = statsTemplateMap;
    }

    public void setResourceList(List<String> resourceList) {
        this.resourceList = resourceList;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    @Override
    public void report(Summary summary, Backtester backtester) throws IOException {
        this.report(summary, backtester, true);
    }

    public void report(Summary summary, Backtester backtester, boolean copyResources) throws IOException {
        if (copyResources) {
            this.copyResources();
        }
        SimpleBindings model = new SimpleBindings();
        model.put(KEY_TIMESTAMP, (Object)new Date());
        model.put(KEY_BACKTESTER, (Object)backtester);
        model.put(KEY_SUMMARY, (Object)summary);
        model.put("win", (Object)summary.getWinSummary());
        model.put("loss", (Object)summary.getLossSummary());
        model.put("stats", (Object)summary.getStatsMap());
        try {
            for (Map.Entry<String, String> entry : this.summaryTemplateMap.entrySet()) {
                TextFileReporter.marge(this.freemarker.getTemplate(entry.getKey()), model, FilenameUtils.concat((String)this.dir, (String)entry.getValue()));
            }
        }
        catch (TemplateException e) {
            throw new IOException(e.getMessage(), e);
        }
        Map<String, Stats> statsMap = summary.getStatsMap();
        for (Map.Entry<String, Stats> entry : statsMap.entrySet()) {
            this.report(entry.getValue(), false);
        }
    }

    @Override
    public void report(Stats stats) throws IOException {
        this.report(stats, true);
    }

    public void report(Stats stats, boolean copyResources) throws IOException {
        if (copyResources) {
            this.copyResources();
        }
        SimpleBindings model = new SimpleBindings();
        model.put(KEY_TIMESTAMP, (Object)new Date());
        model.put(KEY_SYMBOL, (Object)stats.getSymbol());
        model.put(KEY_SYMBOL_NAME, (Object)stats.getSymbolName());
        model.put("stats", (Object)stats);
        model.put(KEY_LONG_STATS, (Object)stats.getLongStats());
        model.put(KEY_SHORT_STATS, (Object)stats.getShortStats());
        model.put("win", (Object)stats.getWinStats());
        model.put("loss", (Object)stats.getLossStats());
        model.put(KEY_TRADE_LIST, (Object)stats.getTradeList());
        try {
            for (Map.Entry<String, String> entry : this.statsTemplateMap.entrySet()) {
                TextFileReporter.marge(this.freemarker.getTemplate(entry.getKey()), model, FilenameUtils.concat((String)this.dir, (String)String.format(entry.getValue(), stats.getSymbol())));
            }
        }
        catch (TemplateException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected void copyResources() throws IOException {
        for (String resourceName : this.resourceList) {
            String filename = FilenameUtils.concat((String)this.dir, (String)resourceName);
            new File(FilenameUtils.getPath((String)filename)).mkdirs();
            TextFileReporter.copy(this.getClass().getResourceAsStream(DEFAULT_BASE_PATH + resourceName), new FileOutputStream(filename));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream input, OutputStream output) throws IOException {
        try {
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    protected static void marge(Template template, Map<String, Object> model, String filename) throws IOException, TemplateException {
        TextFileReporter.marge(template, model, filename, template.getEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void marge(Template template, Map<String, Object> model, String filename, String encoding) throws IOException, TemplateException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), encoding);
        try {
            template.process(model, (Writer)out);
            ((Writer)out).flush();
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    static {
        defaultConfig.setClassForTemplateLoading(TextFileReporter.class, DEFAULT_BASE_PATH);
        defaultConfig.setDefaultEncoding(DEFAULT_ENCODING);
        defaultSummaryTemplateMap = new HashMap<String, String>();
        defaultSummaryTemplateMap.put("index.ftl", "index.html");
        defaultStatsTemplateMap = new HashMap<String, String>();
        defaultStatsTemplateMap.put("stats.ftl", "%s_stats.html");
        defaultStatsTemplateMap.put("trades.ftl", "%s_trades.html");
        defaultResourceList = new ArrayList<String>(5);
        defaultResourceList.add("error.html");
        defaultResourceList.add("style.css");
        defaultResourceList.add("images/contenth2.gif");
        defaultResourceList.add("images/header.gif");
        defaultResourceList.add("images/sidebarh2.gif");
    }
}

