/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.strategy.filters;

import jp.sourceforge.orangesignal.ta.TechnicalAnalysis;
import jp.sourceforge.orangesignal.ta.dataset.StandardDataset;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

public class VolumeAverageFilter
extends StrategySupport {
    private int period = 1;
    private double upper;
    private double lower = 1000.0;
    private Number[] volume;

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public double getUpper() {
        return this.upper;
    }

    public void setUpper(double upper) {
        this.upper = upper;
    }

    public double getLower() {
        return this.lower;
    }

    public void setLower(double lower) {
        this.lower = lower;
    }

    @Override
    public void init() {
        StandardDataset dataset = this.getDataset();
        this.volume = TechnicalAnalysis.sma((Number[])dataset.getTechnicalVolume(), (int)this.period);
    }

    @Override
    public StrategyStatus process() {
        Number value = this.volume[this.getCurrentDataIndex()];
        return value != null && (this.upper > 0.0 && value.doubleValue() > this.upper || this.lower > 0.0 && value.doubleValue() < this.lower) ? StrategyStatus.FILTER : StrategyStatus.NEXT;
    }

    @Override
    public void terminate() {
        this.volume = null;
    }
}

