/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.strategy.systems;

import java.util.Map;
import jp.sourceforge.orangesignal.ta.CrossSignal;
import jp.sourceforge.orangesignal.ta.TechnicalAnalysis;
import jp.sourceforge.orangesignal.ta.dataset.StandardDataset;
import jp.sourceforge.orangesignal.ta.result.Bands5;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.order.OrderTiming;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

public class BollingerBandsLongEntry
extends StrategySupport {
    private FourPrice price = FourPrice.CLOSE;
    private int period = 20;
    private int num = 2;
    protected Number[] bb;
    protected CrossSignal[] cross;

    public FourPrice getPrice() {
        return this.price;
    }

    public void setPrice(FourPrice price) {
        this.price = price;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    @Override
    public void init() {
        StandardDataset dataset = this.getDataset();
        Number[] high = dataset.getTechnicalHigh();
        Number[] low = dataset.getTechnicalLow();
        Number[] close = dataset.getTechnicalClose();
        Map map = TechnicalAnalysis.bbands((Number[])high, (Number[])low, (Number[])close, (int)this.period, (double)this.num);
        this.bb = (Number[])map.get(Bands5.LOWER_BAND1);
        Number[] price = this.getDataset().getTechnicalPrice(this.price);
        this.cross = TechnicalAnalysis.cross((Number[])price, (Number[])this.bb);
    }

    @Override
    public StrategyStatus process() {
        int i = this.getCurrentDataIndex();
        if (this.cross[i] != null && this.cross[i] == CrossSignal.GOLDEN_CROSS) {
            this.buy(this.getStrategyName(), OrderTiming.NEXT_STOP, this.bb[i].doubleValue());
        }
        return StrategyStatus.NEXT;
    }

    @Override
    public void terminate() {
        this.bb = null;
        this.cross = null;
    }
}

