/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.strategy.systems;

import jp.sourceforge.orangesignal.ta.CrossSignal;
import jp.sourceforge.orangesignal.ta.TechnicalAnalysis;
import jp.sourceforge.orangesignal.ta.result.FourPrice;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

public class RSILongEntry
extends StrategySupport {
    private FourPrice price = FourPrice.CLOSE;
    private int period = 14;
    private double signal = 30.0;
    private CrossSignal[] cross;

    public FourPrice getPrice() {
        return this.price;
    }

    public void setPrice(FourPrice price) {
        this.price = price;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public double getSignal() {
        return this.signal;
    }

    public void setSignal(double signal) {
        this.signal = signal;
    }

    @Override
    public void init() {
        Number[] price = this.getDataset().getTechnicalPrice(this.price);
        this.cross = TechnicalAnalysis.cross((Number[])TechnicalAnalysis.rsi((Number[])TechnicalAnalysis.chg((Number[])price), (int)this.period), (double)this.signal);
    }

    @Override
    public StrategyStatus process() {
        int i = this.getCurrentDataIndex();
        if (this.cross[i] != null && this.cross[i] == CrossSignal.GOLDEN_CROSS) {
            this.buy(this.getStrategyName());
        }
        return StrategyStatus.NEXT;
    }

    @Override
    public void terminate() {
        this.cross = null;
    }
}

