/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.trading.util;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.ClassUtils;

public final class StringManager {
    private ResourceBundle bundle;
    private static final Map<String, StringManager> managers = new Hashtable<String, StringManager>();

    private StringManager(String packageName) {
        this.bundle = ResourceBundle.getBundle(packageName + ".LocalStrings");
    }

    public String getString(String key, Object ... obj) {
        String s = this.bundle.getString(key);
        if (obj != null && obj.length > 0) {
            return new MessageFormat(s).format(obj);
        }
        return s;
    }

    public static StringManager getManager(Class cls) {
        return StringManager.getManager(ClassUtils.getPackageName((Class)cls));
    }

    public static synchronized StringManager getManager(String packageName) {
        StringManager manager = managers.get(packageName);
        if (manager == null) {
            manager = new StringManager(packageName);
            managers.put(packageName, manager);
        }
        return manager;
    }
}

