/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta.candle.generator;

import java.util.Date;
import jp.sourceforge.orangesignal.ta.ArrayDataUtils;
import jp.sourceforge.orangesignal.ta.TechnicalAnalysis;
import jp.sourceforge.orangesignal.ta.candle.Candlestick;
import jp.sourceforge.orangesignal.ta.candle.CandlestickColor;
import jp.sourceforge.orangesignal.ta.candle.RealBodyType;
import jp.sourceforge.orangesignal.ta.candle.ShadowType;
import jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSetting;
import jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType;
import jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettings;
import jp.sourceforge.orangesignal.ta.candle.generator.DefaultCandlestick;
import jp.sourceforge.orangesignal.ta.candle.generator.DefaultCandlestickGeneratorSettings;
import jp.sourceforge.orangesignal.ta.candle.generator.TrendProcessor;
import jp.sourceforge.orangesignal.ta.candle.generator.TrendProcessorException;

public class CandlestickGenerator {
    public static final CandlestickGeneratorSettings defaultSettings = new DefaultCandlestickGeneratorSettings();
    protected CandlestickGeneratorSettings settings;

    public CandlestickGeneratorSettings getSettings() {
        return this.settings;
    }

    public void setSettings(CandlestickGeneratorSettings settings) {
        this.settings = settings;
    }

    public CandlestickGenerator() {
        this.settings = defaultSettings;
    }

    public CandlestickGenerator(CandlestickGeneratorSettings settings) {
        this.settings = settings;
    }

    public Candlestick[] generate(Number[] o, Number[] h, Number[] l, Number[] c) {
        return CandlestickGenerator.generate(null, o, h, l, c, null, this.settings);
    }

    public Candlestick[] generate(Date[] d, Number[] o, Number[] h, Number[] l, Number[] c) {
        return CandlestickGenerator.generate(d, o, h, l, c, null, this.settings);
    }

    public Candlestick[] generate(Date[] d, Number[] o, Number[] h, Number[] l, Number[] c, TrendProcessor processor) throws TrendProcessorException {
        return CandlestickGenerator.generate(d, o, h, l, c, processor, this.settings);
    }

    public static Candlestick[] generate(Date[] d, Number[] o, Number[] h, Number[] l, Number[] c, TrendProcessor processor, CandlestickGeneratorSettings settings) throws TrendProcessorException {
        Number[] candle = TechnicalAnalysis.sub(h, l);
        Number[] upper = TechnicalAnalysis.max(o, c);
        Number[] lower = TechnicalAnalysis.min(o, c);
        Number[] body = TechnicalAnalysis.sub(upper, lower);
        Number[] upper_shadow = TechnicalAnalysis.sub(h, upper);
        Number[] lower_shadow = TechnicalAnalysis.sub(lower, l);
        Number[] shadow = TechnicalAnalysis.mult(TechnicalAnalysis.sub(candle, body), 0.5);
        int lengthPeriod = settings.getLengthPeriod();
        Number[] length_candle = TechnicalAnalysis.sma(candle, lengthPeriod);
        Number[] length_body = TechnicalAnalysis.sma(body, lengthPeriod);
        Object[] length_shadow = TechnicalAnalysis.sma(shadow, lengthPeriod);
        int distancePeriod = settings.getDistancePeriod();
        Number[] distance_candle = TechnicalAnalysis.sma(candle, distancePeriod);
        Number[] distance_body = TechnicalAnalysis.sma(body, distancePeriod);
        Number[] distance_shadow = TechnicalAnalysis.sma(shadow, distancePeriod);
        CandlestickGeneratorSetting longBodySetting = settings.getSetting(CandlestickGeneratorSettingType.LONG_BODY);
        CandlestickGeneratorSetting dojiSetting = settings.getSetting(CandlestickGeneratorSettingType.DOJI);
        CandlestickGeneratorSetting longShadowSetting = settings.getSetting(CandlestickGeneratorSettingType.LONG_SHADOW);
        CandlestickGeneratorSetting noShadowSetting = settings.getSetting(CandlestickGeneratorSettingType.NO_SHADOW);
        CandlestickGeneratorSetting sameSetting = settings.getSetting(CandlestickGeneratorSettingType.SAME);
        CandlestickGeneratorSetting nearSetting = settings.getSetting(CandlestickGeneratorSettingType.NEAR);
        CandlestickGeneratorSetting farSetting = settings.getSetting(CandlestickGeneratorSettingType.FAR);
        Number[] longBody = CandlestickGenerator.select(longBodySetting.range, length_candle, length_body, (Number[])length_shadow);
        Number[] doji = CandlestickGenerator.select(dojiSetting.range, length_candle, length_body, (Number[])length_shadow);
        Number[] longShadow = CandlestickGenerator.select(longShadowSetting.range, length_candle, length_body, (Number[])length_shadow);
        Number[] noShadow = CandlestickGenerator.select(noShadowSetting.range, length_candle, length_body, (Number[])length_shadow);
        Number[] same = CandlestickGenerator.select(sameSetting.range, distance_candle, distance_body, distance_shadow);
        Number[] near = CandlestickGenerator.select(nearSetting.range, distance_candle, distance_body, distance_shadow);
        Number[] far = CandlestickGenerator.select(farSetting.range, distance_candle, distance_body, distance_shadow);
        int max = Math.min(Math.min(o.length, c.length), Math.min(h.length, l.length));
        Candlestick[] results = new DefaultCandlestick[max];
        int first = ArrayDataUtils.indexOfNotNull(length_shadow, 0);
        if (first == -1) {
            return results;
        }
        for (int i = 0; i < max; ++i) {
            if (o[i] == null || h[i] == null || l[i] == null || c[i] == null) continue;
            DefaultCandlestick result = new DefaultCandlestick();
            if (d != null && d[i] != null) {
                result.date = (Date)d[i].clone();
            }
            result.open = o[i].doubleValue();
            result.high = h[i].doubleValue();
            result.low = l[i].doubleValue();
            result.close = c[i].doubleValue();
            result.color = result.open <= result.close ? CandlestickColor.WHITE : CandlestickColor.BLACK;
            double _body = body[i].doubleValue();
            result.bodyType = _body > CandlestickGenerator.defaultValue(longBody, i, first) * longBodySetting.factor ? RealBodyType.LONG : (_body < CandlestickGenerator.defaultValue(doji, i, first) * dojiSetting.factor ? RealBodyType.DOJI : RealBodyType.SMALL);
            double _longShadow = CandlestickGenerator.defaultValue(longShadow, i, first) * longShadowSetting.factor;
            double _noShadow = CandlestickGenerator.defaultValue(noShadow, i, first) * noShadowSetting.factor;
            double _upper_shadow = upper_shadow[i].doubleValue();
            result.upperShadowType = _upper_shadow > _longShadow ? ShadowType.LONG : (_upper_shadow < _noShadow ? ShadowType.NO : ShadowType.SHORT);
            double _lower_shadow = lower_shadow[i].doubleValue();
            result.lowerShadowType = _lower_shadow > _longShadow ? ShadowType.LONG : (_lower_shadow < _noShadow ? ShadowType.NO : ShadowType.SHORT);
            result.near = CandlestickGenerator.defaultValue(near, i, first) * nearSetting.factor;
            result.far = CandlestickGenerator.defaultValue(far, i, first) * farSetting.factor;
            result.same = CandlestickGenerator.defaultValue(same, i, first) * sameSetting.factor;
            results[i] = result;
        }
        if (processor != null) {
            processor.execute((DefaultCandlestick[])results);
        }
        return results;
    }

    private static Number[] select(CandlestickGeneratorSetting.Range range, Number[] candle, Number[] body, Number[] shadow) {
        switch (range) {
            case CANDLE: {
                return candle;
            }
            case BODY: {
                return body;
            }
            case SHADOW: {
                return shadow;
            }
        }
        throw new RuntimeException();
    }

    private static double defaultValue(Number[] x, int index, int defaultIndex) {
        if (x[index] != null) {
            return x[index].doubleValue();
        }
        return x[defaultIndex].doubleValue();
    }
}

