/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta.candle.generator;

import java.util.EnumMap;
import java.util.Map;
import jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSetting;
import jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType;
import jp.sourceforge.orangesignal.ta.candle.generator.CandlestickGeneratorSettings;

public class DefaultCandlestickGeneratorSettings
implements CandlestickGeneratorSettings {
    private Map<CandlestickGeneratorSettingType, CandlestickGeneratorSetting> settings;
    private int lengthPeriod;
    private int distancePeriod;

    public DefaultCandlestickGeneratorSettings() {
        this.setSettings(DefaultCandlestickGeneratorSettings.createDefaultSettings());
        this.setLengthPeriod(10);
        this.setDistancePeriod(5);
    }

    public DefaultCandlestickGeneratorSettings(Map<CandlestickGeneratorSettingType, CandlestickGeneratorSetting> settings, int lengthPeriod, int distancePeriod) throws NullPointerException, IllegalArgumentException {
        this.setSettings(settings);
        this.setLengthPeriod(lengthPeriod);
        this.setDistancePeriod(distancePeriod);
    }

    public final Map<CandlestickGeneratorSettingType, CandlestickGeneratorSetting> getSettings() {
        return this.settings;
    }

    public final void setSettings(Map<CandlestickGeneratorSettingType, CandlestickGeneratorSetting> settings) throws NullPointerException {
        if (settings == null) {
            throw new NullPointerException();
        }
        this.settings = settings;
    }

    @Override
    public final CandlestickGeneratorSetting getSetting(CandlestickGeneratorSettingType type) {
        return this.settings.get((Object)type);
    }

    @Override
    public final int getLengthPeriod() {
        return this.lengthPeriod;
    }

    public final void setLengthPeriod(int lengthPeriod) throws IllegalArgumentException {
        if (lengthPeriod <= 0) {
            throw new IllegalArgumentException();
        }
        this.lengthPeriod = lengthPeriod;
    }

    @Override
    public final int getDistancePeriod() {
        return this.distancePeriod;
    }

    public final void setDistancePeriod(int distancePeriod) throws IllegalArgumentException {
        if (distancePeriod <= 0) {
            throw new IllegalArgumentException();
        }
        this.distancePeriod = distancePeriod;
    }

    protected static final Map<CandlestickGeneratorSettingType, CandlestickGeneratorSetting> createDefaultSettings() {
        EnumMap<CandlestickGeneratorSettingType, CandlestickGeneratorSetting> settings = new EnumMap<CandlestickGeneratorSettingType, CandlestickGeneratorSetting>(CandlestickGeneratorSettingType.class);
        settings.put(CandlestickGeneratorSettingType.LONG_BODY, new CandlestickGeneratorSetting(CandlestickGeneratorSetting.Range.BODY, 1.0));
        settings.put(CandlestickGeneratorSettingType.DOJI, new CandlestickGeneratorSetting(CandlestickGeneratorSetting.Range.BODY, 0.1));
        settings.put(CandlestickGeneratorSettingType.LONG_SHADOW, new CandlestickGeneratorSetting(CandlestickGeneratorSetting.Range.BODY, 1.0));
        settings.put(CandlestickGeneratorSettingType.NO_SHADOW, new CandlestickGeneratorSetting(CandlestickGeneratorSetting.Range.CANDLE, 0.1));
        settings.put(CandlestickGeneratorSettingType.SAME, new CandlestickGeneratorSetting(CandlestickGeneratorSetting.Range.CANDLE, 0.05));
        settings.put(CandlestickGeneratorSettingType.NEAR, new CandlestickGeneratorSetting(CandlestickGeneratorSetting.Range.CANDLE, 0.2));
        settings.put(CandlestickGeneratorSettingType.FAR, new CandlestickGeneratorSetting(CandlestickGeneratorSetting.Range.CANDLE, 0.6));
        return settings;
    }
}

