/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading;

/**
 * 口座情報のインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface Account {

	/**
	 * 残高を返します。
	 * 
	 * @return 残高
	 */
	public double getCash();

	/**
	 * 金利を返します。
	 * 
	 * @return 金利
	 */
	public double getInterestRate();

	/**
	 * 預金します。
	 * 
	 * @param amount 入金額
	 * @throws IllegalArgumentException 入金額に <code>0</code> 以下の値が指定された場合
	 */
	public void deposit(double amount);

	/**
	 * 引出します。
	 * 
	 * @param amount 出金額
	 * @return 引出せたかどうか
	 * @throws IllegalArgumentException 出金額に <code>0</code> 以下の値が指定された場合
	 */
	public boolean withdraw(final double amount);

}