/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.backtest;

import java.util.EventObject;

import jp.sourceforge.orangesignal.trading.stats.Stats;

/**
 * バックテスト進行状況を表すイベント情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class BacktesterEvent extends EventObject {

	private static final long serialVersionUID = 1L;

	/**
	 * コンストラクタです。
	 * 
	 * @param source イベントの発生元のオブジェクト
	 * @param max データセットの数
	 * @param count データセットの処理数
	 * @param symbol 処理対象データセットのシンボル
	 * @param symbolName 処理対象データセットのシンボル名
	 * @param stats 処理対象のパフォーマンス統計情報
	 */
	public BacktesterEvent(
			final Object source,
			final int max,
			final int count,
			final String symbol,
			final String symbolName,
			final Stats stats)
	{
		super(source);
		this.max = max;
		this.count = count;
		this.symbol = symbol;
		this.symbolName = symbolName;
		this.stats = stats;
	}

	/**
	 * データセットの数を保持します。
	 */
	protected int max;

	/**
	 * データセットの数を返します。
	 * 
	 * @return データセット
	 */
	public int getMax() { return max; }

	/**
	 * データセットの処理数を保持します。
	 */
	protected int count;

	/**
	 * データセットの処理数を返します。
	 * 
	 * @return データセットの処理数
	 */
	public int getCount() { return count; }

	/**
	 * 処理対象データセットのシンボルを保持します。
	 */
	protected String symbol;

	/**
	 * 処理対象データセットのシンボルを返します。
	 * 
	 * @return 処理対象データセットのシンボル
	 */
	public String getSymbol() { return symbol; }

	/**
	 * 処理対象データセットのシンボル名を保持します。
	 */
	protected String symbolName;

	/**
	 * 処理対象データセットのシンボル名を返します。
	 * 
	 * @return 処理対象データセットのシンボル名
	 */
	public String getSymbolName() { return symbolName; }

	/**
	 * 処理対象のパフォーマンス統計情報を保持します。
	 */
	protected Stats stats;

	/**
	 * 処理対象のパフォーマンス統計情報を返します。
	 * 
	 * @return 処理対象のパフォーマンス統計情報。又は <code>null</code>
	 */
	public Stats getStats() { return stats; }

}
