/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.trading.strategy.filters;

import jp.sourceforge.orangesignal.ta.candle.Candlestick;
import jp.sourceforge.orangesignal.trading.strategy.StrategyStatus;
import jp.sourceforge.orangesignal.trading.strategy.StrategySupport;

/**
 * 価格の範囲でフィルターするストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class PriceFilter extends StrategySupport {

	/**
	 * デフォルトコンストラクタです。
	 */
	public PriceFilter() {}

	/**
	 * 上限価格を保持します。
	 */
	private double upper;

	/**
	 * 上限価格を返します。
	 * 
	 * @return 上限価格
	 */
	public double getUpper() { return upper; }

	/**
	 * 上限価格を設定します。
	 * 
	 * @param upper 上限価格
	 */
	public void setUpper(final double upper) { this.upper = upper; }

	/**
	 * 下限価格を保持します。
	 */
	private double lower = 50;

	/**
	 * 下限価格を返します。
	 * 
	 * @return 下限価格
	 */
	public double getLower() { return lower; }

	/**
	 * 下限価格を設定します。
	 * 
	 * @param lower 下限価格
	 */
	public void setLower(final double lower) { this.lower = lower; }

	@Override
	public StrategyStatus process() {
		final Candlestick c = getCandlestick();
		return (c != null && ((upper > 0 && c.getHigh() > upper) || (lower > 0 && c.getLow() < lower))) ? StrategyStatus.FILTER : StrategyStatus.NEXT;
	}

}
