/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.orangesignal.ta;

public final class ArrayDataConverter {
    private ArrayDataConverter() {
    }

    public static Number[] toPrice(int[] price) {
        int length = price.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (price[i] == 0) continue;
            results[i] = price[i];
        }
        return results;
    }

    public static Number[] toPrice(long[] price) {
        int length = price.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (price[i] == 0L) continue;
            results[i] = price[i];
        }
        return results;
    }

    public static Number[] toPrice(float[] price) {
        int length = price.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (price[i] == 0.0f) continue;
            results[i] = Float.valueOf(price[i]);
        }
        return results;
    }

    public static Number[] toPrice(double[] price) {
        int length = price.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (price[i] == 0.0) continue;
            results[i] = price[i];
        }
        return results;
    }

    public static Number[] toTechnicalPrice(int[] price) {
        int length = price.length;
        Number[] results = new Number[length];
        Integer last = null;
        for (int i = 0; i < length; ++i) {
            if (price[i] != 0) {
                last = price[i];
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] toTechnicalPrice(long[] price) {
        int length = price.length;
        Number[] results = new Number[length];
        Long last = null;
        for (int i = 0; i < length; ++i) {
            if (price[i] != 0L) {
                last = price[i];
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] toTechnicalPrice(float[] price) {
        int length = price.length;
        Number[] results = new Number[length];
        Float last = null;
        for (int i = 0; i < length; ++i) {
            if (price[i] != 0.0f) {
                last = Float.valueOf(price[i]);
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] toTechnicalPrice(double[] price) {
        int length = price.length;
        Number[] results = new Number[length];
        Double last = null;
        for (int i = 0; i < length; ++i) {
            if (price[i] != 0.0) {
                last = price[i];
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] toTechnicalPrice(Number[] price) {
        return ArrayDataConverter.toTechnicalPrice(price, 0, price.length);
    }

    public static Number[] toTechnicalPrice(Number[] price, int start) {
        return ArrayDataConverter.toTechnicalPrice(price, start, price.length);
    }

    public static Number[] toTechnicalPrice(Number[] price, int start, int end) {
        int _start = Math.max(start, 0);
        int _end = Math.min(Math.max(end, 0), price.length);
        Number[] results = new Number[_end - _start];
        Double last = null;
        for (int i = _start; i < _end; ++i) {
            if (price[i] != null) {
                last = price[i].doubleValue();
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] toTechnicalVolume(int[] volume) {
        int length = volume.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = volume[i];
        }
        return results;
    }

    public static Number[] toTechnicalVolume(long[] volume) {
        int length = volume.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = volume[i];
        }
        return results;
    }

    public static Number[] toTechnicalVolume(float[] volume) {
        int length = volume.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = Float.valueOf(volume[i]);
        }
        return results;
    }

    public static Number[] toTechnicalVolume(double[] volume) {
        int length = volume.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = volume[i];
        }
        return results;
    }

    public static Number[] toTechnicalVolume(Number[] volume) {
        return ArrayDataConverter.toTechnicalVolume(volume, 0, volume.length);
    }

    public static Number[] toTechnicalVolume(Number[] volume, int start) {
        return ArrayDataConverter.toTechnicalVolume(volume, start, volume.length);
    }

    public static Number[] toTechnicalVolume(Number[] volume, int start, int end) {
        int _start = Math.max(start, 0);
        int _end = Math.min(Math.max(end, 0), volume.length);
        Number[] results = new Number[_end - _start];
        for (int i = _start; i < _end; ++i) {
            results[i] = volume[i] == null ? (Number)0 : (Number)volume[i].doubleValue();
        }
        return results;
    }
}

