/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 */

package jp.sourceforge.orangesignal.ta.candle.generator;

/**
 * ローソク足情報生成時に使用されるローソク足生成設定群情報のインターフェースです。
 * 
 * @author 杉澤 浩二
 */
public interface CandlestickGeneratorSettings {

	/**
	 * 指定された種類のローソク足情報生成設定情報を返します。<p>
	 * 実装はパラメータで指定された {@link CandlestickGeneratorSettingType} の値により、
	 * 適切なローソク足情報生成設定情報を返す必要があります。
	 * 
	 * @param type ローソク足情報生成設定情報の種類
	 * @return ローソク足生成設定情報
	 */
	public CandlestickGeneratorSetting getSetting(final CandlestickGeneratorSettingType type);

	/**
	 * ローソク足の長さ基準期間を返します。<p>
	 * 実装は必ず正の値を返す必要があります。
	 * 
	 * @return ローソク足の長さ基準期間
	 */
	public int getLengthPeriod();

	/**
	 * ローソク足の距離基準期間を返します。<p>
	 * 実装は必ず正の値を返す必要があります。
	 * 
	 * @return ローソク足の距離基準期間
	 */
	public int getDistancePeriod();

}