/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.dataset;

import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.ta.candle.generator.CandlestickGenerator;
import jp.sf.orangesignal.ta.data.DataConvertUtils;
import jp.sf.orangesignal.ta.dataset.DefaultDataType;
import jp.sf.orangesignal.ta.dataset.TimeSeriesDataset;
import jp.sf.orangesignal.ta.result.FourPrice;

public class StandardDataset
extends TimeSeriesDataset {
    private Candlestick[] candlestick;

    public StandardDataset(TimeSeriesDataset dataset) {
        this(dataset, true);
    }

    public StandardDataset(TimeSeriesDataset dataset, boolean candlestick) {
        super(dataset);
        this.setupTechnicalPrice();
        if (candlestick) {
            this.candlestick = new CandlestickGenerator().generate(this.getDate(), this.getOpen(), this.getHigh(), this.getLow(), this.getClose());
        }
    }

    private final void setupTechnicalPrice() {
        Number[] array = this.getOpen();
        if (array != null) {
            array = DataConvertUtils.previousIfNull(array);
            this.setData(DefaultDataType.TECHNICAL_OPEN, array);
        }
        if ((array = this.getHigh()) != null) {
            array = DataConvertUtils.previousIfNull(array);
            this.setData(DefaultDataType.TECHNICAL_HIGH, array);
        }
        if ((array = this.getLow()) != null) {
            array = DataConvertUtils.previousIfNull(array);
            this.setData(DefaultDataType.TECHNICAL_LOW, array);
        }
        if ((array = this.getClose()) != null) {
            array = DataConvertUtils.previousIfNull(array);
            this.setData(DefaultDataType.TECHNICAL_CLOSE, array);
        }
        if ((array = this.getVolume()) != null) {
            array = DataConvertUtils.zeroIfNull(array);
            this.setData(DefaultDataType.TECHNICAL_VOLUME, array);
        }
    }

    public final Number[] getTechnicalPrice(FourPrice type) {
        switch (type) {
            case OPEN: {
                return this.getTechnicalOpen();
            }
            case HIGH: {
                return this.getTechnicalHigh();
            }
            case LOW: {
                return this.getTechnicalLow();
            }
            case CLOSE: {
                return this.getTechnicalClose();
            }
        }
        return null;
    }

    public final Number[] getTechnicalOpen() {
        return this.getData(DefaultDataType.TECHNICAL_OPEN);
    }

    public final Number[] getTechnicalHigh() {
        return this.getData(DefaultDataType.TECHNICAL_HIGH);
    }

    public final Number[] getTechnicalLow() {
        return this.getData(DefaultDataType.TECHNICAL_LOW);
    }

    public final Number[] getTechnicalClose() {
        return this.getData(DefaultDataType.TECHNICAL_CLOSE);
    }

    public final Number[] getTechnicalVolume() {
        return this.getData(DefaultDataType.TECHNICAL_VOLUME);
    }

    public Candlestick[] getCandlestick() {
        return this.candlestick;
    }

    public Candlestick getCandlestick(int i) {
        return this.candlestick == null ? null : this.candlestick[i];
    }
}

