/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.util;

import java.lang.reflect.Array;

public abstract class ArrayUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int INDEX_NOT_FOUND = -1;

    public static int getMinLength(Object[] ... arrays) {
        int result = 0;
        for (Object[] array : arrays) {
            if (array == null) continue;
            int length = array.length;
            if (result != 0 && result <= length) continue;
            result = length;
        }
        return result;
    }

    public static int getMaxLength(Object[] ... arrays) {
        int result = 0;
        for (Object[] array : arrays) {
            if (array == null) continue;
            int length = array.length;
            if (result != 0 && result >= length) continue;
            result = length;
        }
        return result;
    }

    public static boolean isSameLength(Object[] ... arrays) {
        return ArrayUtils.getMinLength(arrays) == ArrayUtils.getMaxLength(arrays);
    }

    public static int notNullIndexOf(Object[] array) {
        return ArrayUtils.notNullIndexOf(array, 0);
    }

    public static int notNullIndexOf(Object[] array, int start) {
        int length = ArrayUtils.getMinLength(new Object[][]{array});
        for (int i = Math.max(start, 0); i < length; ++i) {
            if (array[i] == null) continue;
            return i;
        }
        return -1;
    }

    public static int notNullLastIndexOf(Object[] array) {
        return ArrayUtils.notNullLastIndexOf(array, Integer.MAX_VALUE);
    }

    public static int notNullLastIndexOf(Object[] array, int start) {
        int _start;
        for (int i = _start = start < (length = ArrayUtils.getMinLength(new Object[][]{array})) ? start : length - 1; i >= 0; --i) {
            if (array[i] == null) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] extend(T[] array, int space) {
        if (array == null) {
            return null;
        }
        if (space == 0) {
            return array;
        }
        int length = array.length;
        int abs = Math.abs(space);
        int newSize = length + abs;
        Class<?> type = array.getClass().getComponentType();
        Object[] results = (Object[])Array.newInstance(type, newSize);
        if (space > 0) {
            System.arraycopy(array, 0, results, 0, length);
        } else {
            System.arraycopy(array, 0, results, abs, length);
        }
        return results;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return array != null && array.length > 0;
    }
}

