/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

/**
 * Java プログラム要素からデータセット機能やローソク足分析などを使用するための注釈を定義します。
 * 
 * <pre>
 * 例:
 * &#064;DatePattern(value = "yyyy/MM/dd", language = "ja", country = "JP", timezone = "Asia/Tokyo")
 * &#064;NumberPattern(value = "#,##0", language = "ja", country = "JP")
 * &#064;NumberCompressorType(CompressType.SUM)
 * public class Dataset {
 * 
 *     &#064;DateItem
 *     &#064;DatePattern(value = "yyyy/MM/dd", language = "ja", country = "JP", timezone = "Asia/Tokyo")
 *     Date[] date;
 * 
 *     &#064;NumberItem
 *     &#064;NumberPattern(value = "\u00A4\u00A4 #,##0", language = "ja", country = "JP", currency = "JPY")
 *     &#064;NumberCompressorType(CompressType.FIRST)
 *     Number[] open;
 * 
 *     &#064;NumberItem
 *     &#064;NumberPattern(value = "\u00A4\u00A4 #,##0", language = "ja", country = "JP", currency = "JPY")
 *     &#064;NumberCompressorType(CompressType.HIGHEST)
 *     Number[] high;
 * 
 *     &#064;NumberItem
 *     &#064;NumberPattern(value = "\u00A4\u00A4 #,##0", language = "ja", country = "JP", currency = "JPY")
 *     &#064;NumberCompressorType(CompressType.LOWEST)
 *     Number[] low;
 * 
 *     &#064;NumberItem
 *     &#064;NumberPattern(value = "\u00A4\u00A4 #,##0", language = "ja", country = "JP", currency = "JPY")
 *     &#064;NumberCompressorType(CompressType.LAST)
 *     Number[] close;
 * 
 *     &#064;NumberItem
 *     &#064;NumberPattern(value = "#,##0", language = "ja", country = "JP")
 *     &#064;NumberCompressorType(CompressType.SUM)
 *     Number[] volume;
 * 
 * }
 * </pre>
 * 
 * @since 2.1
 */
package jp.sf.orangesignal.ta.data.annotation;

