/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.dataset.loader;

import java.util.EventObject;

import jp.sf.orangesignal.ta.dataset.TimeSeriesDataset;

/**
 * データセットがロードされた事を表すイベント情報を提供します。
 * 
 * @author 杉澤 浩二
 * @since 1.1
 */
public final class DatasetLoadEvent extends EventObject {

	private static final long serialVersionUID = 1L;

	/**
	 * データセットを保持します。
	 */
	private transient TimeSeriesDataset dataset;

	/**
	 * コンストラクタです。
	 * 
	 * @param source イベントの発生元のオブジェクト
	 * @param dataset データセット
	 */
	public DatasetLoadEvent(final Object source, final TimeSeriesDataset dataset) {
		super(source);
		this.dataset = dataset;
	}

	/**
	 * データセットを返します。
	 * 
	 * @return データセット
	 */
	public TimeSeriesDataset getDataset() { return dataset; }

}
