/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.dataset.loader;

import java.util.Date;

import jp.sf.orangesignal.ta.dataset.PriceVolumeData;

/**
 * 価格データを提供します。
 * 
 * @author 杉澤 浩二
 * @see PriceDataLoader
 * @since 1.1
 */
public class OHLCV implements PriceVolumeData {

	protected Date date;
	@Override public Date getDate() { return date; }
	public void setDate(final Date date) { this.date = date; }

	protected Number open;
	@Override public Number getOpen() { return open; }
	public void setOpen(final Number open) { this.open = open; }

	protected Number high;
	@Override public Number getHigh() { return high; }
	public void setHigh(final Number high) { this.high = high; }

	protected Number low;
	@Override public Number getLow() { return low; }
	public void setLow(final Number low) { this.low = low; }

	protected Number close;
	@Override public Number getClose() { return close; }
	public void setClose(final Number close) { this.close = close; }

	protected Number volume;
	@Override public Number getVolume() { return volume; }
	public void setVolume(final Number volume) { this.volume = volume; }

}
