/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.candle.generator;

import java.io.Serializable;
import java.util.Date;
import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.ta.candle.CandlestickColor;
import jp.sf.orangesignal.ta.candle.RealBodyType;
import jp.sf.orangesignal.ta.candle.ShadowType;
import jp.sf.orangesignal.ta.candle.TrendType;

public class DefaultCandlestick
implements Candlestick,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TrendType trend;
    protected CandlestickColor color;
    protected RealBodyType bodyType;
    protected ShadowType upperShadowType;
    protected ShadowType lowerShadowType;
    protected Date date;
    protected double open;
    protected double high;
    protected double low;
    protected double close;
    protected double same;
    protected double near;
    protected double far;

    protected DefaultCandlestick() {
    }

    @Override
    public TrendType getTrend() {
        return this.trend;
    }

    @Override
    public CandlestickColor getColor() {
        return this.color;
    }

    @Override
    public RealBodyType getBodyType() {
        return this.bodyType;
    }

    @Override
    public ShadowType getUpperShadowType() {
        return this.upperShadowType;
    }

    @Override
    public ShadowType getLowerShadowType() {
        return this.lowerShadowType;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public double getOpen() {
        return this.open;
    }

    @Override
    public double getHigh() {
        return this.high;
    }

    @Override
    public double getLow() {
        return this.low;
    }

    @Override
    public double getClose() {
        return this.close;
    }

    @Override
    public double length() {
        return this.high - this.low;
    }

    @Override
    public double median() {
        return (this.high + this.low) * 0.5;
    }

    @Override
    public double body() {
        return Math.abs(this.close - this.open);
    }

    @Override
    public double upperBody() {
        return Math.max(this.open, this.close);
    }

    @Override
    public double lowerBody() {
        return Math.min(this.open, this.close);
    }

    @Override
    public double midpoint() {
        return (this.close + this.open) * 0.5;
    }

    @Override
    public double shadow() {
        return this.length() - this.body();
    }

    @Override
    public double upperShadow() {
        return this.high - this.upperBody();
    }

    @Override
    public double lowerShadow() {
        return this.lowerBody() - this.low;
    }

    @Override
    public boolean isLongWhite() {
        return this.color == CandlestickColor.WHITE && this.bodyType == RealBodyType.LONG && this.upperShadowType != ShadowType.LONG && this.lowerShadowType != ShadowType.LONG;
    }

    @Override
    public boolean isLongBlack() {
        return this.color == CandlestickColor.BLACK && this.bodyType == RealBodyType.LONG && this.upperShadowType != ShadowType.LONG && this.lowerShadowType != ShadowType.LONG;
    }

    @Override
    public boolean isShortWhite() {
        return this.color == CandlestickColor.BLACK && this.bodyType == RealBodyType.SMALL && this.upperShadowType != ShadowType.LONG && this.lowerShadowType != ShadowType.LONG;
    }

    @Override
    public boolean isShortBlack() {
        return this.color == CandlestickColor.WHITE && this.bodyType == RealBodyType.SMALL && this.upperShadowType != ShadowType.LONG && this.lowerShadowType != ShadowType.LONG;
    }

    @Override
    public boolean isMarubozu() {
        return this.bodyType == RealBodyType.LONG && this.upperShadowType == ShadowType.NO && this.lowerShadowType == ShadowType.NO;
    }

    @Override
    public boolean isOpeningMarubozu() {
        switch (this.color) {
            case WHITE: {
                return this.bodyType == RealBodyType.LONG && this.upperShadowType != ShadowType.NO && this.lowerShadowType == ShadowType.NO;
            }
            case BLACK: {
                return this.bodyType == RealBodyType.LONG && this.upperShadowType == ShadowType.NO && this.lowerShadowType != ShadowType.NO;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isClosingMarubozu() {
        switch (this.color) {
            case WHITE: {
                return this.bodyType == RealBodyType.LONG && this.upperShadowType == ShadowType.NO && this.lowerShadowType != ShadowType.NO;
            }
            case BLACK: {
                return this.bodyType == RealBodyType.LONG && this.upperShadowType != ShadowType.NO && this.lowerShadowType == ShadowType.NO;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isSmallMarubozu() {
        return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.NO && this.lowerShadowType == ShadowType.NO;
    }

    @Override
    public boolean isSmallOpeningMarubozu() {
        switch (this.color) {
            case WHITE: {
                return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.SHORT && this.lowerShadowType == ShadowType.NO;
            }
            case BLACK: {
                return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.NO && this.lowerShadowType == ShadowType.SHORT;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isSmallClosingMarubozu() {
        switch (this.color) {
            case WHITE: {
                return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.NO && this.lowerShadowType == ShadowType.SHORT;
            }
            case BLACK: {
                return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.SHORT && this.lowerShadowType == ShadowType.NO;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public boolean isSpinningTop() {
        return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.SHORT && this.lowerShadowType == ShadowType.SHORT;
    }

    @Override
    public boolean isHighWave() {
        return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.LONG && this.lowerShadowType == ShadowType.LONG;
    }

    @Override
    public boolean isHangingMan() {
        return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.NO && this.lowerShadowType == ShadowType.LONG;
    }

    @Override
    public boolean isShootingStar() {
        return this.bodyType == RealBodyType.SMALL && this.upperShadowType == ShadowType.LONG && this.lowerShadowType == ShadowType.NO;
    }

    @Override
    public boolean isLongLeggedDoji() {
        return this.bodyType == RealBodyType.DOJI && this.upperShadowType == ShadowType.LONG && this.lowerShadowType == ShadowType.LONG;
    }

    @Override
    public boolean isGravestoneDoji() {
        return this.bodyType == RealBodyType.DOJI && this.upperShadowType == ShadowType.LONG && this.lowerShadowType == ShadowType.NO;
    }

    @Override
    public boolean isDragonflyDoji() {
        return this.bodyType == RealBodyType.DOJI && this.upperShadowType == ShadowType.NO && this.lowerShadowType == ShadowType.LONG;
    }

    @Override
    public boolean isFourPriceDoji() {
        return this.bodyType == RealBodyType.DOJI && this.upperShadowType == ShadowType.NO && this.lowerShadowType == ShadowType.NO;
    }

    @Override
    public boolean contains(double a) {
        return this.high >= a && this.low <= a;
    }

    @Override
    public boolean contains(double a, double b) {
        return this.high >= Math.max(a, b) && this.low <= Math.min(a, b);
    }

    @Override
    public boolean contains(Candlestick c) {
        return this.high >= c.getHigh() && this.low <= c.getLow();
    }

    @Override
    public boolean containsByBody(Candlestick c) {
        return this.high >= c.upperBody() && this.low <= c.lowerBody();
    }

    @Override
    public boolean containsBody(double a) {
        return this.upperBody() >= a && this.lowerBody() <= a;
    }

    @Override
    public boolean containsBody(double a, double b) {
        return this.upperBody() >= Math.max(a, b) && this.lowerBody() <= Math.min(a, b);
    }

    @Override
    public boolean containsBody(Candlestick c) {
        return this.upperBody() >= c.getHigh() && this.lowerBody() <= c.getLow();
    }

    @Override
    public boolean containsBodyByBody(Candlestick c) {
        return this.upperBody() >= c.upperBody() && this.lowerBody() <= c.lowerBody();
    }

    @Override
    public boolean overlaps(double a, double b) {
        return this.contains(a) || this.contains(b);
    }

    @Override
    public boolean overlaps(Candlestick c) {
        return this.contains(c.getHigh()) || this.contains(c.getLow());
    }

    @Override
    public boolean overlapsByBody(Candlestick c) {
        return this.contains(c.upperBody()) || this.contains(c.lowerBody());
    }

    @Override
    public boolean overlapsBody(double a, double b) {
        return this.containsBody(a) || this.containsBody(b);
    }

    @Override
    public boolean overlapsBody(Candlestick c) {
        return this.containsBody(c.getHigh()) || this.containsBody(c.getLow());
    }

    @Override
    public boolean overlapsBodyByBody(Candlestick c) {
        return this.containsBody(c.upperBody()) || this.containsBody(c.lowerBody());
    }

    @Override
    public boolean gap(double a, double b) {
        return !this.overlaps(a, b);
    }

    @Override
    public boolean gap(Candlestick c) {
        return !this.overlaps(c);
    }

    @Override
    public boolean gapByBody(Candlestick c) {
        return !this.overlapsByBody(c);
    }

    @Override
    public boolean gapBody(double a, double b) {
        return !this.overlapsBody(a, b);
    }

    @Override
    public boolean gapBody(Candlestick c) {
        return !this.overlapsBody(c);
    }

    @Override
    public boolean gapBodyByBody(Candlestick c) {
        return !this.overlapsBodyByBody(c);
    }

    @Override
    public boolean gapUp(double a, double b) {
        return this.high < Math.min(a, b);
    }

    @Override
    public boolean gapUp(Candlestick c) {
        return this.high < c.getLow();
    }

    @Override
    public boolean gapUpByBody(Candlestick c) {
        return this.high < c.lowerBody();
    }

    @Override
    public boolean gapUpBody(double a, double b) {
        return this.upperBody() < Math.min(a, b);
    }

    @Override
    public boolean gapUpBody(Candlestick c) {
        return this.upperBody() < c.getLow();
    }

    @Override
    public boolean gapUpBodyByBody(Candlestick c) {
        return this.upperBody() < c.lowerBody();
    }

    @Override
    public boolean gapDown(double a, double b) {
        return this.low > Math.max(a, b);
    }

    @Override
    public boolean gapDown(Candlestick c) {
        return this.low > c.getHigh();
    }

    @Override
    public boolean gapDownByBody(Candlestick c) {
        return this.low > c.upperBody();
    }

    @Override
    public boolean gapDownBody(double a, double b) {
        return this.lowerBody() > Math.max(a, b);
    }

    @Override
    public boolean gapDownBody(Candlestick c) {
        return this.lowerBody() > c.getHigh();
    }

    @Override
    public boolean gapDownBodyByBody(Candlestick c) {
        return this.lowerBody() > c.upperBody();
    }

    @Override
    public boolean isSameOpen(double a) {
        return this.isSame(this.open, a);
    }

    @Override
    public boolean isSameHigh(double a) {
        return this.isSame(this.high, a);
    }

    @Override
    public boolean isSameLow(double a) {
        return this.isSame(this.low, a);
    }

    @Override
    public boolean isSameClose(double a) {
        return this.isSame(this.close, a);
    }

    @Override
    public boolean isSame(double a, double b) {
        return Math.abs(a - b) < this.same;
    }

    @Override
    public boolean isNearOpen(double a) {
        return this.isNear(this.open, a);
    }

    @Override
    public boolean isNearHigh(double a) {
        return this.isNear(this.high, a);
    }

    @Override
    public boolean isNearLow(double a) {
        return this.isNear(this.low, a);
    }

    @Override
    public boolean isNearClose(double a) {
        return this.isNear(this.close, a);
    }

    @Override
    public boolean isNear(double a, double b) {
        return Math.abs(a - b) < this.near;
    }

    @Override
    public boolean isFarOpen(double a) {
        return this.isFar(this.open, a);
    }

    @Override
    public boolean isFarHigh(double a) {
        return this.isFar(this.high, a);
    }

    @Override
    public boolean isFarLow(double a) {
        return this.isFar(this.low, a);
    }

    @Override
    public boolean isFarClose(double a) {
        return this.isFar(this.close, a);
    }

    @Override
    public boolean isFar(double a, double b) {
        return Math.abs(a - b) > this.far;
    }

    @Override
    public boolean isCloseInBottomQuarter() {
        return this.close >= this.low + this.length() * 0.75;
    }

    @Override
    public boolean isCloseInTopQuarter() {
        return this.close <= this.low + this.length() * 0.25;
    }
}

