/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.data.annotation;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.DataConvertUtils;
import jp.sf.orangesignal.ta.data.DatasetItems;
import jp.sf.orangesignal.ta.data.DatasetSource;
import jp.sf.orangesignal.ta.data.DateFormatConfig;
import jp.sf.orangesignal.ta.data.NumberFormatConfig;
import jp.sf.orangesignal.ta.data.annotation.AnnotationException;
import jp.sf.orangesignal.ta.data.annotation.AnnotationUtils;
import jp.sf.orangesignal.ta.data.annotation.DateItem;
import jp.sf.orangesignal.ta.data.annotation.DatePattern;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.annotation.NumberItem;
import jp.sf.orangesignal.ta.data.annotation.NumberPattern;
import jp.sf.orangesignal.ta.util.Assert;
import jp.sf.orangesignal.ta.util.StringUtils;

public abstract class AnnotationParser {
    public static DatasetSource parse(Object obj) {
        Assert.notNull(obj, "Dataset must not be null");
        Class<?> cls = obj.getClass();
        DateFormatConfig defaultDateFormatConfig = AnnotationParser.createDateFormatConfig(cls.getAnnotation(DatePattern.class));
        NumberFormatConfig defaultNumberFormatConfig = AnnotationParser.createNumberFormatConfig(cls.getAnnotation(NumberPattern.class));
        CompressType defaultCompressType = (CompressType)((Object)AnnotationUtils.getValue(cls.getAnnotation(NumberCompressorType.class)));
        DatasetItems items = new DatasetItems();
        for (Field field : cls.getDeclaredFields()) {
            try {
                Number[] number;
                NumberItem data;
                field.setAccessible(true);
                Object value = field.get(obj);
                DateItem datetime = field.getAnnotation(DateItem.class);
                if (datetime != null) {
                    Date[] date;
                    String name = StringUtils.defaultIfEmpty(datetime.value(), field.getName());
                    DateFormatConfig config = AnnotationParser.createDateFormatConfig(field, defaultDateFormatConfig);
                    if (value instanceof Collection) {
                        date = DataConvertUtils.toDateArray((Collection)value, config);
                    } else if (value instanceof Object[]) {
                        date = DataConvertUtils.toDateArray((Object[])value, config);
                    } else {
                        throw new AnnotationException("unknown type");
                    }
                    items.setDate(name, date);
                    items.setDateFormatConfig(name, config);
                }
                if ((data = field.getAnnotation(NumberItem.class)) == null) continue;
                String name = StringUtils.defaultIfEmpty(data.value(), field.getName());
                NumberFormatConfig config = AnnotationParser.createNumberFormatConfig(field, defaultNumberFormatConfig);
                if (value instanceof Collection) {
                    number = DataConvertUtils.toNumberArray((Collection)value, config);
                } else if (value instanceof Object[]) {
                    number = DataConvertUtils.toNumberArray((Object[])value, config);
                } else {
                    throw new AnnotationException("unknown type");
                }
                items.setNumber(name, number);
                items.setNumberFormatConfig(name, config);
                items.setCompressType(name, AnnotationParser.getCompressorType(field, defaultCompressType));
            }
            catch (IllegalAccessException e) {
                throw new AnnotationException(e.getMessage(), e);
            }
        }
        return items;
    }

    public static DatasetSource parse(Collection<?> collection) {
        Assert.notNull(collection, "Collection must not be null");
        return AnnotationParser.parse(collection.toArray());
    }

    public static DatasetSource parse(Object[] array) {
        Assert.notNull(array, "Array must not be null");
        int length = array.length;
        final class InnerItems {
            private int initialCapacity;
            Map<String, List<Date>> dateMap = new HashMap<String, List<Date>>();
            Map<String, List<Number>> dataMap = new HashMap<String, List<Number>>();

            public InnerItems(int initialCapacity) {
                this.initialCapacity = initialCapacity;
            }

            public void add(String name, Date date) {
                List<Date> list = this.dateMap.get(name);
                if (list != null) {
                    list.add(date);
                } else {
                    list = new ArrayList<Date>(this.initialCapacity);
                    list.add(date);
                    this.dateMap.put(name, list);
                }
            }

            public void add(String name, Number number) {
                List<Number> list = this.dataMap.get(name);
                if (list != null) {
                    list.add(number);
                } else {
                    list = new ArrayList<Number>(this.initialCapacity);
                    list.add(number);
                    this.dataMap.put(name, list);
                }
            }
        }
        InnerItems inner = new InnerItems(length);
        DatasetItems items = new DatasetItems();
        for (int i = 0; i < length; ++i) {
            Object object = array[i];
            if (object == null) continue;
            Class<?> cls = object.getClass();
            DateFormatConfig defaultDateFormatConfig = AnnotationParser.createDateFormatConfig(cls.getAnnotation(DatePattern.class));
            NumberFormatConfig defaultNumberFormatConfig = AnnotationParser.createNumberFormatConfig(cls.getAnnotation(NumberPattern.class));
            CompressType defaultCompressType = (CompressType)((Object)AnnotationUtils.getValue(cls.getAnnotation(NumberCompressorType.class)));
            for (Field field : cls.getDeclaredFields()) {
                try {
                    NumberItem data;
                    field.setAccessible(true);
                    Object value = field.get(object);
                    DateItem datetime = field.getAnnotation(DateItem.class);
                    if (datetime != null) {
                        if (value == null) {
                            // empty if block
                        }
                        String name = StringUtils.defaultIfEmpty(datetime.value(), field.getName());
                        DateFormatConfig config = AnnotationParser.createDateFormatConfig(field, defaultDateFormatConfig);
                        Date date = DataConvertUtils.toDate(value, config);
                        inner.add(name, date);
                        items.setDateFormatConfig(name, config);
                    }
                    if ((data = field.getAnnotation(NumberItem.class)) == null) continue;
                    String name = StringUtils.defaultIfEmpty(data.value(), field.getName());
                    NumberFormatConfig config = AnnotationParser.createNumberFormatConfig(field, defaultNumberFormatConfig);
                    Number number = DataConvertUtils.toNumber(value, config);
                    inner.add(name, number);
                    items.setNumberFormatConfig(name, config);
                    items.setCompressType(name, AnnotationParser.getCompressorType(field, defaultCompressType));
                }
                catch (IllegalAccessException e) {
                    throw new AnnotationException(e.getMessage(), e);
                }
            }
        }
        for (Map.Entry<String, List<Date>> entry : inner.dateMap.entrySet()) {
            items.setDate(entry.getKey(), entry.getValue().toArray(new Date[0]));
        }
        for (Map.Entry<String, List<Serializable>> entry : inner.dataMap.entrySet()) {
            items.setNumber(entry.getKey(), entry.getValue().toArray(new Number[0]));
        }
        return items;
    }

    private static DateFormatConfig createDateFormatConfig(DatePattern annotation) {
        if (annotation == null) {
            return null;
        }
        return new DateFormatConfig(annotation.value(), AnnotationParser.getLocale(annotation.language(), annotation.country(), null), StringUtils.isNotEmpty(annotation.timezone()) ? TimeZone.getTimeZone(annotation.timezone()) : null);
    }

    private static NumberFormatConfig createNumberFormatConfig(NumberPattern annotation) {
        if (annotation == null) {
            return null;
        }
        return new NumberFormatConfig(annotation.value(), AnnotationParser.getLocale(annotation.language(), annotation.country(), null), annotation.currency());
    }

    private static DateFormatConfig createDateFormatConfig(Field field, DateFormatConfig defaultConfig) {
        DateFormatConfig config = AnnotationParser.createDateFormatConfig(field.getAnnotation(DatePattern.class));
        if (config == null) {
            return defaultConfig;
        }
        return config;
    }

    private static NumberFormatConfig createNumberFormatConfig(Field field, NumberFormatConfig defaultConfig) {
        NumberFormatConfig config = AnnotationParser.createNumberFormatConfig(field.getAnnotation(NumberPattern.class));
        if (config == null) {
            return defaultConfig;
        }
        return config;
    }

    private static Locale getLocale(String language, String country, Locale defaultLocale) {
        if (language != null && !language.isEmpty()) {
            return new Locale(language, country != null ? country : "", "");
        }
        return defaultLocale;
    }

    private static CompressType getCompressorType(Field field, CompressType defaultCompressType) {
        CompressType compressType = (CompressType)((Object)AnnotationUtils.getValue(field.getAnnotation(NumberCompressorType.class)));
        if (compressType != null) {
            return compressType;
        }
        return defaultCompressType;
    }
}

