/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.order;

import java.util.Date;

import jp.sf.orangesignal.ta.result.FourPrice;

/**
 * <p>当日の終値で成行注文する注文情報を提供します。</p>
 * 
 * @author 杉澤 浩二
 */
public final class CurrentCloseOrder extends AbstractMarketOrder {

	private static final long serialVersionUID = 3180812283682520806L;

	/**
	 * コンストラクタです。
	 * 
	 * @param symbol シンボル
	 * @param label ラベル
	 * @param date 注文日時
	 * @param quantity 数量
	 * @param findId 決済注文ID
	 * @param findLabel 決済注文ラベル
	 * @throws NullPointerException パラメーターに <code>null</code> を指定した場合
	 */
	public CurrentCloseOrder(
			final String symbol,
			final String label,
			final Date date,
			final int quantity,
			final Integer findId,
			final String findLabel)
	{
		super(symbol, label, date, quantity, findId, findLabel);
	}

	/**
	 * この実装は必ず <code>0</code> を返します。
	 */
	@Override public int getPeriod() { return 0; }

	/**
	 * この実装は必ず {@link FourPrice#CLOSE} を返します。
	 */
	@Override public FourPrice getPriceType() { return FourPrice.CLOSE; }

}
