/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.stop;

import static jp.sf.orangesignal.trading.PositionType.LONG;
import static jp.sf.orangesignal.trading.PositionType.SHORT;
import static jp.sf.orangesignal.trading.order.OrderTiming.NEXT_LIMIT;

import java.util.List;

import jp.sf.orangesignal.ta.PercentageScale;
import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * ポジションが目標利益に達した場合に、指値注文するストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class ProfitTarget extends TradingStrategySupport {

	private double profit;

	public double getProfit() { return profit; }

	public void setProfit(final double profit) { this.profit = profit; }

	private PercentageScale scale;

	public PercentageScale getScale() { return scale; }

	public void setScale(final PercentageScale scale) { this.scale = scale; }

	@Override
	public boolean execute() {
		final List<Position> positions = getCurrentPositions();
		for (final Position p : positions) {
			final double profit = (this.scale == null) ? this.profit : Math.ceil(p.getEntryPrice() * (this.profit / this.scale.scale()));
			if (p.getType() == LONG)
				sell(getStrategyName(), NEXT_LIMIT, p.getEntryPrice() + profit, p.getEntryLabel());
			else if (p.getType() == SHORT)
				buyToCover(getStrategyName(), NEXT_LIMIT, p.getEntryPrice() - profit, p.getEntryLabel());
		}
		return false;
	}

}
