/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.systems;

import static jp.sf.orangesignal.ta.TechnicalAnalysis.cross;
import static jp.sf.orangesignal.ta.TechnicalAnalysis.ma;
import jp.sf.orangesignal.ta.CrossSignal;
import jp.sf.orangesignal.ta.MovingAverage;
import jp.sf.orangesignal.ta.result.FourPrice;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * 短期移動平均と長期移動平均の交差をシグナルとするストラテジーの基底クラスを提供します。
 */
public abstract class MovingAverage2LineCross extends TradingStrategySupport {

	/**
	 * 価格の種類を保持します。
	 */
	private FourPrice price = FourPrice.CLOSE;

	/**
	 * 価格の種類を返します。
	 * 
	 * @return 価格の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 価格の種類を設定します。
	 * 
	 * @param price 価格の種類
	 */
	public void setPrice(FourPrice price) { this.price = price; }

	/**
	 * 短期移動平均の期間を保持します。
	 */
	private int fast = 9;

	/**
	 * 短期移動平均の期間を返します。
	 * 
	 * @return 短期移動平均の期間
	 */
	public int getFast() { return fast; }

	/**
	 * 短期移動平均の期間を設定します。
	 * 
	 * @param fast 短期移動平均の期間
	 */
	public void setFast(int fast) { this.fast = fast; }

	/**
	 * 長期移動平均の期間を保持します。
	 */
	private int slow = 18;

	/**
	 * 長期移動平均の期間を返します。
	 * 
	 * @return 長期移動平均の期間
	 */
	public int getSlow() { return slow; }

	/**
	 * 長期移動平均の期間を設定します。
	 * 
	 * @param slow 長期移動平均の期間
	 */
	public void setSlow(int slow) { this.slow = slow; }

	/**
	 * 移動平均の種類を保持します。
	 */
	private MovingAverage type = MovingAverage.SMA;

	/**
	 * 移動平均の種類を返します。
	 * 
	 * @return 移動平均の種類
	 */
	public MovingAverage getType() { return type; }

	/**
	 * 移動平均の種類を設定します。
	 * 
	 * @param type 移動平均の種類
	 */
	public void setType(MovingAverage type) { this.type = type; }

	// ----------------------------------------------------------------------

	/**
	 * 短期移動平均と長期移動平均の交差シグナルを保持します。
	 */
	protected CrossSignal[] cross;

	@Override
	public void prepare() {
		final Number[] price = getDataset().getTechnicalPrice(this.price);
		final Number[] ma_fast = ma(price, this.fast, this.type);
		final Number[] ma_slow = ma(price, this.slow, this.type);
		this.cross = cross(ma_fast, ma_slow);
	}

	@Override
	public void close() {
		this.cross = null;
	}

}
