/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.systems;

import static jp.sf.orangesignal.ta.CrossSignal.GOLDEN_CROSS;
import static jp.sf.orangesignal.ta.TechnicalAnalysis.chg;
import static jp.sf.orangesignal.ta.TechnicalAnalysis.cross;
import static jp.sf.orangesignal.ta.TechnicalAnalysis.rsi;
import jp.sf.orangesignal.ta.CrossSignal;
import jp.sf.orangesignal.ta.result.FourPrice;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

public class RSILongEntry extends TradingStrategySupport {

	// ----------------------------------------------------------------------
	// パラメーター

	private FourPrice price = FourPrice.CLOSE;
	public FourPrice getPrice() { return price; }
	public void setPrice(final FourPrice price) { this.price = price; }

	private int period = 14;
	public int getPeriod() { return period; }
	public void setPeriod(final int period) { this.period = period; }

	private double signal = 30;
	public double getSignal() { return signal; }
	public void setSignal(final double signal) { this.signal = signal; }

	// ----------------------------------------------------------------------
	// 処理

	private CrossSignal[] cross;

	@Override
	public void prepare() {
		final Number[] price = getDataset().getTechnicalPrice(this.price);
		this.cross = cross(rsi(chg(price), this.period), signal);
	}

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (cross[i] != null && cross[i] == GOLDEN_CROSS)
			buy(getStrategyName());
		return false;
	}

	@Override
	public void close() {
		this.cross = null;
	}

}
