/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.data;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import jp.sf.orangesignal.ta.data.DataConvertUtils;
import jp.sf.orangesignal.ta.data.DatasetBindException;
import jp.sf.orangesignal.ta.data.DatasetSource;
import jp.sf.orangesignal.ta.util.ArrayUtils;
import jp.sf.orangesignal.ta.util.Assert;

public class DatasetBinder<T> {
    private DatasetSource source;
    private T dataset;
    private String[] includeNames;
    private String[] excludeNames;

    public DatasetBinder(DatasetSource source, T dataset) {
        Assert.notNull(source, "DatasetSource must not be null");
        Assert.notNull(dataset, "Dataset must not be null");
        this.source = source;
        this.dataset = dataset;
    }

    public DatasetBinder<T> includes(String ... names) {
        Assert.isEmpty(this.excludeNames, "Only includes or excludes may be specified.");
        this.includeNames = names;
        return this;
    }

    public DatasetBinder<T> excludes(String ... names) {
        Assert.isEmpty(this.includeNames, "Only includes or excludes may be specified.");
        this.excludeNames = names;
        return this;
    }

    private boolean isTargetName(String name) {
        if (ArrayUtils.isNotEmpty(this.excludeNames)) {
            for (String propertyName : this.excludeNames) {
                if (!propertyName.equals(name)) continue;
                return false;
            }
            return true;
        }
        if (ArrayUtils.isNotEmpty(this.includeNames)) {
            for (String propertyName : this.includeNames) {
                if (!propertyName.equals(name)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T execute() throws DatasetBindException {
        try {
            Collection list;
            List<Object> c;
            Class<?> fieldType;
            Field field;
            String name;
            Class<?> cls = this.dataset.getClass();
            for (Map.Entry<String, Date[]> entry : this.source.getDateMap().entrySet()) {
                void var7_10;
                name = entry.getKey();
                if (!this.isTargetName(name)) continue;
                field = cls.getDeclaredField(name);
                fieldType = field.getType();
                if (fieldType.isArray() && String.class.isAssignableFrom(fieldType.getComponentType())) {
                    String[] stringArray = DataConvertUtils.toStringArray(entry.getValue(), this.source.getDateFormatConfig(name));
                } else if (Collection.class.isAssignableFrom(fieldType)) {
                    c = Arrays.asList((Object[])entry.getValue());
                    if (!fieldType.isInterface()) {
                        list = (Collection)fieldType.newInstance();
                        list.addAll(c);
                        Collection collection = list;
                    } else if (List.class.isAssignableFrom(fieldType)) {
                        ArrayList<Object> arrayList = new ArrayList<Object>(c);
                    } else if (Set.class.isAssignableFrom(fieldType)) {
                        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(c);
                    } else {
                        if (!Queue.class.isAssignableFrom(fieldType)) throw new IllegalStateException("this dataset field type unsupported: " + fieldType.getName());
                        LinkedList<Object> linkedList = new LinkedList<Object>(c);
                    }
                } else {
                    Date[] dateArray = entry.getValue();
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(this.dataset, var7_10);
            }
            for (Map.Entry<String, Serializable[]> entry : this.source.getNumberMap().entrySet()) {
                void var7_26;
                name = entry.getKey();
                if (!this.isTargetName(name)) continue;
                field = cls.getDeclaredField(name);
                fieldType = field.getType();
                if (fieldType.isArray() && String.class.isAssignableFrom(fieldType.getComponentType())) {
                    String[] stringArray = DataConvertUtils.toStringArray((Number[])entry.getValue(), this.source.getNumberFormatConfig(name));
                } else if (Collection.class.isAssignableFrom(fieldType)) {
                    c = Arrays.asList((Object[])entry.getValue());
                    if (!fieldType.isInterface()) {
                        list = (Collection)fieldType.newInstance();
                        list.addAll(c);
                        Collection collection = list;
                    } else if (List.class.isAssignableFrom(fieldType)) {
                        ArrayList<Object> arrayList = new ArrayList<Object>(c);
                    } else if (Set.class.isAssignableFrom(fieldType)) {
                        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(c);
                    } else {
                        if (!Queue.class.isAssignableFrom(fieldType)) throw new IllegalStateException("this dataset field type unsupported: " + fieldType.getName());
                        LinkedList<Object> linkedList = new LinkedList<Object>(c);
                    }
                } else {
                    Serializable[] serializableArray = entry.getValue();
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(this.dataset, var7_26);
            }
            return this.dataset;
        }
        catch (Exception e) {
            throw new DatasetBindException(e.getMessage(), e);
        }
    }
}

