/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.annotation.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.dxo.annotation.AnnotationReader;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.beans.util.BeanUtil;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.ConstantAnnotationUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MapUtil;

public class ConstantAnnotationReader
implements AnnotationReader {
    protected S2Container container;
    protected Map convertersCache = MapUtil.createHashMap();

    public ConstantAnnotationReader(S2Container container) {
        this.container = container.getRoot();
    }

    public String getDatePattern(Class dxoClass, Method method) {
        return this.getDatePattern(dxoClass, method, "DATE_PATTERN");
    }

    public String getTimePattern(Class dxoClass, Method method) {
        return this.getDatePattern(dxoClass, method, "TIME_PATTERN");
    }

    public String getTimestampPattern(Class dxoClass, Method method) {
        return this.getDatePattern(dxoClass, method, "TIMESTAMP_PATTERN");
    }

    public String getConversionRule(Class dxoClass, Method method) {
        String fieldName;
        BeanDesc dxoBeanDesc = BeanDescFactory.getBeanDesc((Class)dxoClass);
        if (dxoBeanDesc.hasField(fieldName = this.getConstantAnnotationName(method, "CONVERSION_RULE"))) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        fieldName = method.getName() + "_" + "CONVERSION_RULE";
        if (dxoBeanDesc.hasField(fieldName)) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        return null;
    }

    public boolean isExcludeNull(Class dxoClass, Method method) {
        String fieldName;
        BeanDesc dxoBeanDesc = BeanDescFactory.getBeanDesc((Class)dxoClass);
        if (dxoBeanDesc.hasField(fieldName = this.getConstantAnnotationName(method, "EXCLUDE_NULL"))) {
            return true;
        }
        fieldName = method.getName() + "_" + "EXCLUDE_NULL";
        return dxoBeanDesc.hasField(fieldName);
    }

    public String getSourcePrefix(Class dxoClass, Method method) {
        String fieldName;
        BeanDesc dxoBeanDesc = BeanDescFactory.getBeanDesc((Class)dxoClass);
        if (dxoBeanDesc.hasField(fieldName = this.getConstantAnnotationName(method, "SOURCE_PREFIX"))) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        fieldName = method.getName() + "_" + "SOURCE_PREFIX";
        if (dxoBeanDesc.hasField(fieldName)) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        return null;
    }

    public Map getConverters(Class destClass) {
        Map converters = (Map)this.convertersCache.get(destClass);
        if (converters != null) {
            return converters;
        }
        return this.createConverters(destClass);
    }

    protected String getDatePattern(Class dxoClass, Method method, String annotation) {
        String fieldName;
        BeanDesc dxoBeanDesc = BeanDescFactory.getBeanDesc((Class)dxoClass);
        if (dxoBeanDesc.hasField(fieldName = this.getConstantAnnotationName(method, annotation))) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        fieldName = method.getName() + "_" + annotation;
        if (dxoBeanDesc.hasField(fieldName)) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        fieldName = annotation;
        if (dxoBeanDesc.hasField(fieldName)) {
            return (String)dxoBeanDesc.getFieldValue(fieldName, null);
        }
        return null;
    }

    protected Map createConverters(Class destClass) {
        HashMap<String, Converter> converters = new HashMap<String, Converter>();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)destClass);
        for (int i = 0; i < beanDesc.getFieldSize(); ++i) {
            String converterName;
            int index;
            String fieldName;
            String propertyName;
            Field field = beanDesc.getField(i);
            if (!ConstantAnnotationUtil.isConstantAnnotation((Field)field) || !field.getName().endsWith("DxoConverter") || !beanDesc.hasPropertyDesc(propertyName = (fieldName = field.getName()).substring(0, index = fieldName.lastIndexOf("_"))) || !this.container.hasComponentDef((Object)(converterName = fieldName.substring(index + 1)))) continue;
            Converter converter = (Converter)this.container.getComponent((Object)converterName);
            String s = (String)FieldUtil.get((Field)field, null);
            Map props = ConstantAnnotationUtil.convertExpressionToMap((String)s);
            BeanUtil.copyProperties((Map)props, (Object)converter);
            converters.put(propertyName, converter);
        }
        this.convertersCache.put(destClass, converters);
        return converters;
    }

    protected String getConstantAnnotationName(Method method, String suffix) {
        StringBuffer buf = new StringBuffer(100).append(method.getName());
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            buf.append("_").append(this.getShortClassName(parameterTypes[i]));
        }
        buf.append("_").append(suffix);
        return new String(buf);
    }

    protected String getShortClassName(Class clazz) {
        if (clazz.isArray()) {
            return ClassUtil.getShortClassName(clazz.getComponentType()) + "$";
        }
        return ClassUtil.getShortClassName((Class)clazz);
    }
}

