/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.extension.dxo.converter.DatePropertyInfo;
import org.seasar.extension.dxo.converter.NestedPropertyInfo;
import org.seasar.extension.dxo.converter.ParameterizedClassConverter;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.InstantiationRuntimeException;
import org.seasar.framework.util.ClassUtil;

public class BeanConverter
extends AbstractConverter {
    protected static final Object PROPERTY_NOT_FOUND = new Object();

    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Class getDestClass() {
        return Object.class;
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = source.getClass();
        if (sourceClass == Object.class || sourceClass == String.class || sourceClass == Boolean.class || sourceClass == Character.class || Number.class.isAssignableFrom(sourceClass)) {
            return source;
        }
        if (this.shallowCopy && destClass.isAssignableFrom(sourceClass)) {
            return source;
        }
        Object converted = context.getConvertedObject(source);
        if (converted != null) {
            return converted;
        }
        try {
            Object dest = ClassUtil.newInstance((Class)destClass);
            this.convert(source, dest, context);
            return dest;
        }
        catch (InstantiationRuntimeException ignore) {
            return null;
        }
    }

    public void convert(Object source, Object dest, ConversionContext context) {
        context.addConvertedObject(source, dest);
        this.setValues(source, dest, context);
    }

    protected void setValues(Object source, Object dest, ConversionContext context) {
        BeanDesc sourceBeanDesc = BeanDescFactory.getBeanDesc(source.getClass());
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        int size = destBeanDesc.getPropertyDescSize();
        for (int i = 0; i < size; ++i) {
            PropertyDesc destPropertyDesc = destBeanDesc.getPropertyDesc(i);
            if (!destPropertyDesc.isWritable()) continue;
            this.setValue(sourceBeanDesc, source, destBeanDesc, dest, destPropertyDesc, context);
        }
    }

    protected void setValue(BeanDesc sourceBeanDesc, Object source, BeanDesc destBeanDesc, Object dest, PropertyDesc destPropertyDesc, ConversionContext context) {
        String destPropertyName = destPropertyDesc.getPropertyName();
        Class destPropertyClass = destPropertyDesc.getPropertyType();
        Object sourcePropertyValue = this.getSourceValue(sourceBeanDesc, source, destPropertyName, context);
        if (sourcePropertyValue == PROPERTY_NOT_FOUND) {
            Object dateValue = this.getDateValue(sourceBeanDesc, source, destPropertyName, destPropertyClass, context);
            if (dateValue != null) {
                destPropertyDesc.setValue(dest, dateValue);
            }
            return;
        }
        if (sourcePropertyValue == null) {
            if (context.isIncludeNull()) {
                destPropertyDesc.setValue(dest, null);
            }
            return;
        }
        Class<?> sourcePropertyClass = sourcePropertyValue.getClass();
        if (this.shallowCopy && sourcePropertyClass.isAssignableFrom(destPropertyClass)) {
            destPropertyDesc.setValue(dest, sourcePropertyValue);
            return;
        }
        Converter converter = this.getConverter(sourcePropertyClass, dest.getClass(), destPropertyName, destPropertyClass, context);
        if (converter instanceof ParameterizedClassConverter && destPropertyDesc.isParameterized()) {
            Object convertedValue = ((ParameterizedClassConverter)converter).convert(sourcePropertyValue, destPropertyClass, destPropertyDesc.getParameterizedClassDesc(), context);
            destPropertyDesc.setValue(dest, convertedValue);
            return;
        }
        Object convertedValue = converter.convert(sourcePropertyValue, destPropertyClass, context);
        destPropertyDesc.setValue(dest, convertedValue);
    }

    protected Object getSourceValue(BeanDesc sourceBeanDesc, Object source, String destPropertyName, ConversionContext context) {
        String sourcePropertyName = context.getSourcePropertyName(destPropertyName);
        if (context.hasEvalueatedValue(sourcePropertyName)) {
            return context.getEvaluatedValue(sourcePropertyName);
        }
        if (sourceBeanDesc.hasPropertyDesc(sourcePropertyName)) {
            PropertyDesc sourcePropertyDesc = sourceBeanDesc.getPropertyDesc(sourcePropertyName);
            if (!sourcePropertyDesc.isReadable()) {
                return PROPERTY_NOT_FOUND;
            }
            return sourcePropertyDesc.getValue(source);
        }
        return this.resolveNestedProperty(sourceBeanDesc, source, sourcePropertyName, context);
    }

    protected Object resolveNestedProperty(BeanDesc sourceBeanDesc, Object source, String propertyName, ConversionContext context) {
        NestedPropertyInfo info = context.getNestedPropertyInfo(sourceBeanDesc.getBeanClass(), propertyName);
        if (info == null) {
            return PROPERTY_NOT_FOUND;
        }
        return info.getValue(source);
    }

    protected Object getDateValue(BeanDesc sourceBeanDesc, Object source, String destPropertyName, Class destPropertyType, ConversionContext context) {
        Date dateValue;
        if (destPropertyType == String.class) {
            return this.getDateValueAsString(sourceBeanDesc, source, destPropertyName);
        }
        if (Date.class.isAssignableFrom(destPropertyType) && (dateValue = this.getDateValueAsDate(sourceBeanDesc.getBeanClass(), source, destPropertyName, context)) != null) {
            if (destPropertyType.isAssignableFrom(Date.class)) {
                return dateValue;
            }
            if (destPropertyType.isAssignableFrom(java.sql.Date.class)) {
                return new java.sql.Date(dateValue.getTime());
            }
            if (destPropertyType.isAssignableFrom(Time.class)) {
                return new Time(dateValue.getTime());
            }
            if (destPropertyType.isAssignableFrom(Timestamp.class)) {
                return new Timestamp(dateValue.getTime());
            }
        }
        if (destPropertyType.isAssignableFrom(Calendar.class) && (dateValue = this.getDateValueAsDate(sourceBeanDesc.getBeanClass(), source, destPropertyName, context)) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateValue);
            return calendar;
        }
        return null;
    }

    protected String getDateValueAsString(BeanDesc sourceBeanDesc, Object source, String destPropertyName) {
        Class sourcePropertyType;
        int pos = destPropertyName.lastIndexOf(95);
        if (pos == -1 || pos >= destPropertyName.length() - 1) {
            return null;
        }
        String sourcePropertyName = destPropertyName.substring(0, pos);
        if (!sourceBeanDesc.hasPropertyDesc(sourcePropertyName)) {
            return null;
        }
        PropertyDesc sourcePropertyDesc = sourceBeanDesc.getPropertyDesc(sourcePropertyName);
        if (!sourcePropertyDesc.isReadable()) {
            return null;
        }
        if (!Date.class.isAssignableFrom(sourcePropertyType = sourcePropertyDesc.getPropertyType()) && !Calendar.class.isAssignableFrom(sourcePropertyType)) {
            return null;
        }
        Object sourceValue = sourcePropertyDesc.getValue(source);
        if (sourceValue == null) {
            return null;
        }
        String format = destPropertyName.substring(pos + 1);
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        if (sourceValue instanceof Date) {
            return formatter.format((Date)sourceValue);
        }
        if (sourceValue instanceof Calendar) {
            Calendar calendar = (Calendar)sourceValue;
            return formatter.format(new Date(calendar.getTimeInMillis()));
        }
        return null;
    }

    protected Date getDateValueAsDate(Class sourceClass, Object source, String destPropertyName, ConversionContext context) {
        DatePropertyInfo info = context.getDatePropertyInfo(sourceClass, destPropertyName);
        if (info == null) {
            return null;
        }
        return info.getValue(source);
    }

    protected Converter getConverter(Class sourcePropertyClass, Class destClass, String destPropertyName, Class destPropertyClass, ConversionContext context) {
        Converter converter = context.getConverter(destClass, destPropertyName);
        if (converter != null) {
            return converter;
        }
        return context.getConverterFactory().getConverter(sourcePropertyClass, destPropertyClass);
    }
}

