/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.stats.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import jp.sf.orangesignal.ta.dataset.IntervalType;
import jp.sf.orangesignal.trading.backtest.Backtester;
import jp.sf.orangesignal.trading.stats.Stats;
import jp.sf.orangesignal.trading.stats.Summary;
import jp.sf.orangesignal.trading.stats.Trade;
import jp.sf.orangesignal.trading.stats.report.Reporter;
import org.apache.commons.io.FilenameUtils;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class EquityCurveReporter
implements Reporter {
    private DomainAxisType domainAxisType = DomainAxisType.DATE;
    private float tickMarkInsideLength = 0.0f;
    private float tickMarkOutsideLength = 4.0f;
    private Font tickLabelFont = new Font("Verdana", 0, 10);
    private Color gridlineColor = Color.GRAY;
    private Color drawdownColor = Color.RED;
    private boolean visibleAbsoluteDrawdown = true;
    private boolean visiblePercentDrawdown = true;
    protected String dir = ".";
    private String filename = "%s_equity_curve.png";
    private ImageType imageType = ImageType.PNG;
    private float jpegQuality;
    private int width = 1024;
    private int height = 768;

    public void setDomainAxisType(DomainAxisType domainAxisType) {
        this.domainAxisType = domainAxisType;
    }

    public void setTickLabelFont(Font tickLabelFont) {
        this.tickLabelFont = tickLabelFont;
    }

    public void setVisibleAbsoluteDrawdown(boolean visibleAbsoluteDrawdown) {
        this.visibleAbsoluteDrawdown = visibleAbsoluteDrawdown;
    }

    public void setVisiblePercentDrawdown(boolean visiblePercentDrawdown) {
        this.visiblePercentDrawdown = visiblePercentDrawdown;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setImageType(ImageType imageType) {
        this.imageType = imageType;
    }

    public void setJpegQuality(float jpegQuality) {
        this.jpegQuality = jpegQuality;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void report(Summary summary, Backtester backtester) throws IOException {
        Map<String, Stats> statsMap = summary.getStatsMap();
        for (Map.Entry<String, Stats> entry : statsMap.entrySet()) {
            this.report(entry.getValue());
        }
    }

    @Override
    public void report(Stats stats) throws IOException {
        XYPlot percentDrawdownPlot;
        XYPlot absoluteDrawdownPlot;
        Object domainAxis = this.domainAxisType == DomainAxisType.TRADE_NUMBER ? new NumberAxis("Trade Number") : new DateAxis("Date");
        domainAxis.setTickMarkInsideLength(this.tickMarkInsideLength);
        domainAxis.setTickMarkOutsideLength(this.tickMarkOutsideLength);
        domainAxis.setTickLabelFont(this.tickLabelFont);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setLowerMargin(0.0);
        NumberAxis equityAxis = new NumberAxis("Equity");
        equityAxis.setTickMarkInsideLength(this.tickMarkInsideLength);
        equityAxis.setTickMarkOutsideLength(this.tickMarkOutsideLength);
        equityAxis.setTickLabelFont(this.tickLabelFont);
        equityAxis.setAutoRangeIncludesZero(false);
        XYLineAndShapeRenderer equityRenderer = new XYLineAndShapeRenderer(true, false);
        XYPlot equityPlot = new XYPlot(this.getEquityDataset(stats), (ValueAxis)domainAxis, (ValueAxis)equityAxis, (XYItemRenderer)equityRenderer);
        equityPlot.setOutlineVisible(false);
        equityPlot.setBackgroundPaint((Paint)Color.WHITE);
        equityPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        equityPlot.setDomainGridlinePaint((Paint)this.gridlineColor);
        equityPlot.setRangeGridlinePaint((Paint)this.gridlineColor);
        ValueMarker initialCapitalMarker = new ValueMarker(stats.getInitialCapital());
        initialCapitalMarker.setPaint((Paint)Color.BLACK);
        equityPlot.addRangeMarker((Marker)initialCapitalMarker);
        if (this.visibleAbsoluteDrawdown) {
            NumberAxis absoluteDrawdownAxis = new NumberAxis("Drawdown");
            absoluteDrawdownAxis.setTickMarkInsideLength(this.tickMarkInsideLength);
            absoluteDrawdownAxis.setTickMarkOutsideLength(this.tickMarkOutsideLength);
            absoluteDrawdownAxis.setTickLabelFont(this.tickLabelFont);
            absoluteDrawdownAxis.setAutoRangeIncludesZero(true);
            absoluteDrawdownAxis.setPositiveArrowVisible(false);
            XYAreaRenderer absoluteDrawdownRenderer = new XYAreaRenderer();
            absoluteDrawdownRenderer.setSeriesPaint(0, (Paint)this.drawdownColor);
            absoluteDrawdownPlot = new XYPlot(this.getAbsoluteDrawdownDataset(stats), (ValueAxis)domainAxis, (ValueAxis)absoluteDrawdownAxis, (XYItemRenderer)absoluteDrawdownRenderer);
            absoluteDrawdownPlot.setOutlineVisible(false);
            absoluteDrawdownPlot.setBackgroundPaint((Paint)Color.WHITE);
            absoluteDrawdownPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            absoluteDrawdownPlot.setDomainGridlinePaint((Paint)this.gridlineColor);
            absoluteDrawdownPlot.setRangeGridlinePaint((Paint)this.gridlineColor);
        } else {
            absoluteDrawdownPlot = null;
        }
        if (this.visiblePercentDrawdown) {
            NumberAxis percentDrawdownAxis = new NumberAxis("Drawdown(%)");
            percentDrawdownAxis.setTickMarkInsideLength(this.tickMarkInsideLength);
            percentDrawdownAxis.setTickMarkOutsideLength(this.tickMarkOutsideLength);
            percentDrawdownAxis.setTickLabelFont(this.tickLabelFont);
            percentDrawdownAxis.setAutoRangeIncludesZero(true);
            percentDrawdownAxis.setPositiveArrowVisible(false);
            XYAreaRenderer percentDrawdownRenderer = new XYAreaRenderer();
            percentDrawdownRenderer.setSeriesPaint(0, (Paint)this.drawdownColor);
            percentDrawdownPlot = new XYPlot(this.getPercentDrawdownDataset(stats), (ValueAxis)domainAxis, (ValueAxis)percentDrawdownAxis, (XYItemRenderer)percentDrawdownRenderer);
            percentDrawdownPlot.setOutlineVisible(false);
            percentDrawdownPlot.setBackgroundPaint((Paint)Color.WHITE);
            percentDrawdownPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            percentDrawdownPlot.setDomainGridlinePaint((Paint)Color.GRAY);
            percentDrawdownPlot.setRangeGridlinePaint((Paint)Color.GRAY);
        } else {
            percentDrawdownPlot = null;
        }
        CombinedDomainXYPlot plot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        plot.add(equityPlot, 50);
        if (absoluteDrawdownPlot != null) {
            plot.add(absoluteDrawdownPlot, 25);
        }
        if (percentDrawdownPlot != null) {
            plot.add(percentDrawdownPlot, 25);
        }
        JFreeChart chart = new JFreeChart(null, null, (Plot)plot, false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        File file = new File(FilenameUtils.concat((String)this.dir, (String)String.format(this.filename, stats.getSymbol())));
        switch (this.imageType) {
            case PNG: {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)chart, (int)this.width, (int)this.height);
                break;
            }
            case JPEG: {
                ChartUtilities.saveChartAsJPEG((File)file, (float)this.jpegQuality, (JFreeChart)chart, (int)this.width, (int)this.height);
            }
        }
    }

    protected XYDataset getEquityDataset(Stats stats) {
        if (this.domainAxisType == DomainAxisType.TRADE_NUMBER) {
            XYSeries series = new XYSeries((Comparable)((Object)stats.getSymbol()));
            int i = 1;
            for (Trade trade : stats.getTradeList()) {
                series.add((double)i++, trade.getEquity());
            }
            return new XYSeriesCollection(series);
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)stats.getSymbol()));
        IntervalType interval = stats.getInterval();
        for (Trade trade : stats.getTradeList()) {
            series.add(EquityCurveReporter.createRegularTimePeriod(interval, trade.getEntryDate()), trade.getEquity());
        }
        return new TimeSeriesCollection(series);
    }

    protected XYDataset getAbsoluteDrawdownDataset(Stats stats) {
        if (this.domainAxisType == DomainAxisType.TRADE_NUMBER) {
            XYSeries series = new XYSeries((Comparable)((Object)stats.getSymbol()));
            int i = 1;
            for (Trade trade : stats.getTradeList()) {
                series.add((double)i++, trade.getDrawdown());
            }
            return new XYSeriesCollection(series);
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)stats.getSymbol()));
        IntervalType interval = stats.getInterval();
        for (Trade trade : stats.getTradeList()) {
            series.add(EquityCurveReporter.createRegularTimePeriod(interval, trade.getEntryDate()), trade.getDrawdown());
        }
        return new TimeSeriesCollection(series);
    }

    protected XYDataset getPercentDrawdownDataset(Stats stats) {
        if (this.domainAxisType == DomainAxisType.TRADE_NUMBER) {
            XYSeries series = new XYSeries((Comparable)((Object)stats.getSymbol()));
            int i = 1;
            for (Trade trade : stats.getTradeList()) {
                series.add((double)i++, trade.getPercentDrawdown() * 100.0);
            }
            return new XYSeriesCollection(series);
        }
        TimeSeries series = new TimeSeries((Comparable)((Object)stats.getSymbol()));
        IntervalType interval = stats.getInterval();
        for (Trade trade : stats.getTradeList()) {
            series.add(EquityCurveReporter.createRegularTimePeriod(interval, trade.getEntryDate()), trade.getPercentDrawdown() * 100.0);
        }
        return new TimeSeriesCollection(series);
    }

    private static RegularTimePeriod createRegularTimePeriod(IntervalType interval, Date date) {
        switch (interval) {
            case MINUTELY: {
                return new Minute(date);
            }
            case HOURLY: {
                return new Hour(date);
            }
            case DAILY: {
                return new Day(date);
            }
            case WEEKLY: {
                return new Week(date);
            }
            case MONTHLY: {
                return new Month(date);
            }
        }
        return null;
    }

    private static TickUnitSource createStandardDateTickUnits(TimeZone zone, Locale locale) {
        if (zone == null) {
            throw new IllegalArgumentException("Null 'zone' argument.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Null 'locale' argument.");
        }
        TickUnits units = new TickUnits();
        SimpleDateFormat f1 = new SimpleDateFormat("HH:mm:ss.SSS", locale);
        SimpleDateFormat f2 = new SimpleDateFormat("HH:mm:ss", locale);
        SimpleDateFormat f3 = new SimpleDateFormat("HH:mm", locale);
        SimpleDateFormat f4 = new SimpleDateFormat("M/d, HH:mm", locale);
        SimpleDateFormat f5 = new SimpleDateFormat("M/d", locale);
        SimpleDateFormat f6 = new SimpleDateFormat("yyyy/M", locale);
        SimpleDateFormat f7 = new SimpleDateFormat("yyyy", locale);
        f1.setTimeZone(zone);
        f2.setTimeZone(zone);
        f3.setTimeZone(zone);
        f4.setTimeZone(zone);
        f5.setTimeZone(zone);
        f6.setTimeZone(zone);
        f7.setTimeZone(zone);
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MILLISECOND, 1, (DateFormat)f1));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MILLISECOND, 5, DateTickUnitType.MILLISECOND, 1, (DateFormat)f1));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MILLISECOND, 10, DateTickUnitType.MILLISECOND, 1, (DateFormat)f1));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MILLISECOND, 25, DateTickUnitType.MILLISECOND, 5, (DateFormat)f1));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MILLISECOND, 50, DateTickUnitType.MILLISECOND, 10, (DateFormat)f1));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MILLISECOND, 100, DateTickUnitType.MILLISECOND, 10, (DateFormat)f1));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MILLISECOND, 250, DateTickUnitType.MILLISECOND, 10, (DateFormat)f1));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MILLISECOND, 500, DateTickUnitType.MILLISECOND, 50, (DateFormat)f1));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.SECOND, 1, DateTickUnitType.MILLISECOND, 50, (DateFormat)f2));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.SECOND, 5, DateTickUnitType.SECOND, 1, (DateFormat)f2));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.SECOND, 10, DateTickUnitType.SECOND, 1, (DateFormat)f2));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.SECOND, 30, DateTickUnitType.SECOND, 5, (DateFormat)f2));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 1, DateTickUnitType.SECOND, 5, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 2, DateTickUnitType.SECOND, 10, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 5, DateTickUnitType.MINUTE, 1, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 10, DateTickUnitType.MINUTE, 1, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 15, DateTickUnitType.MINUTE, 5, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 20, DateTickUnitType.MINUTE, 5, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MINUTE, 30, DateTickUnitType.MINUTE, 5, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.HOUR, 1, DateTickUnitType.MINUTE, 5, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.HOUR, 2, DateTickUnitType.MINUTE, 10, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.HOUR, 4, DateTickUnitType.MINUTE, 30, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.HOUR, 6, DateTickUnitType.HOUR, 1, (DateFormat)f3));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.HOUR, 12, DateTickUnitType.HOUR, 1, (DateFormat)f4));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 1, DateTickUnitType.HOUR, 1, (DateFormat)f5));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 2, DateTickUnitType.HOUR, 1, (DateFormat)f5));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 7, DateTickUnitType.DAY, 1, (DateFormat)f5));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.DAY, 15, DateTickUnitType.DAY, 1, (DateFormat)f5));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MONTH, 1, DateTickUnitType.DAY, 1, (DateFormat)f6));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MONTH, 2, DateTickUnitType.DAY, 1, (DateFormat)f6));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MONTH, 3, DateTickUnitType.MONTH, 1, (DateFormat)f6));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MONTH, 4, DateTickUnitType.MONTH, 1, (DateFormat)f6));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.MONTH, 6, DateTickUnitType.MONTH, 1, (DateFormat)f6));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 1, DateTickUnitType.MONTH, 1, (DateFormat)f7));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 2, DateTickUnitType.MONTH, 3, (DateFormat)f7));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 5, DateTickUnitType.YEAR, 1, (DateFormat)f7));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 10, DateTickUnitType.YEAR, 1, (DateFormat)f7));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 25, DateTickUnitType.YEAR, 5, (DateFormat)f7));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 50, DateTickUnitType.YEAR, 10, (DateFormat)f7));
        units.add((TickUnit)new DateTickUnit(DateTickUnitType.YEAR, 100, DateTickUnitType.YEAR, 20, (DateFormat)f7));
        return units;
    }

    public static enum ImageType {
        PNG,
        JPEG;

    }

    public static enum DomainAxisType {
        TRADE_NUMBER,
        DATE;

    }
}

