/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.trading.strategy.stop;

import java.util.LinkedList;
import jp.sf.orangesignal.ta.PercentageScale;
import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.PositionType;
import jp.sf.orangesignal.trading.order.OrderTiming;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

public class StopLoss
extends TradingStrategySupport {
    private double loss;
    private PercentageScale scale;

    public double getLoss() {
        return this.loss;
    }

    public void setLoss(double loss) {
        this.loss = loss;
    }

    public PercentageScale getScale() {
        return this.scale;
    }

    public void setScale(PercentageScale scale) {
        this.scale = scale;
    }

    @Override
    public boolean execute() {
        LinkedList<Position> positions = this.getCurrentPositions();
        for (Position p : positions) {
            double loss;
            double d = loss = this.scale == null ? this.loss : Math.ceil(p.getEntryPrice() * (this.loss / this.scale.scale()));
            if (p.getType() == PositionType.LONG) {
                this.sell(this.getStrategyName(), OrderTiming.NEXT_STOP, p.getEntryPrice() - loss, p.getEntryLabel());
                continue;
            }
            if (p.getType() != PositionType.SHORT) continue;
            this.buyToCover(this.getStrategyName(), OrderTiming.NEXT_STOP, p.getEntryPrice() + loss, p.getEntryLabel());
        }
        return false;
    }
}

