/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.sf.orangesignal.csv.handlers.CsvValueConverter;

public class SimpleCsvValueConverter
implements CsvValueConverter {
    private static final Map<Class<?>, Object> primitiveDefaults = new HashMap();
    private static final Map<String, Boolean> booleanDefaults;
    private DateFormat dateFormat;

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public Object convert(String str, Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (str == null) {
            if (type.isPrimitive()) {
                return primitiveDefaults.get(type);
            }
            return null;
        }
        if (type.equals(String.class)) {
            return str;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            for (Map.Entry<String, Boolean> entry : booleanDefaults.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(str)) continue;
                return entry.getValue();
            }
        } else {
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return Byte.valueOf(str);
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return Short.valueOf(str);
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return Integer.valueOf(str);
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return Long.valueOf(str);
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(str);
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return Double.valueOf(str);
            }
            if (type.equals(BigInteger.class)) {
                return new BigInteger(str);
            }
            if (type.equals(Number.class) || type.equals(BigDecimal.class)) {
                return new BigDecimal(str);
            }
            if (this.dateFormat != null && Date.class.isAssignableFrom(type)) {
                try {
                    return type.getConstructor(Long.TYPE).newInstance(this.dateFormat.parse(str).getTime());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unknown convert type %s", type.getName()));
    }

    @Override
    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    static {
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Byte.TYPE, (byte)0);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveDefaults.put(Short.TYPE, (short)0);
        primitiveDefaults.put(Integer.TYPE, 0);
        primitiveDefaults.put(Long.TYPE, 0L);
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, 0.0);
        booleanDefaults = new HashMap<String, Boolean>();
        booleanDefaults.put("0", Boolean.FALSE);
        booleanDefaults.put("1", Boolean.TRUE);
        booleanDefaults.put("false", Boolean.FALSE);
        booleanDefaults.put("true", Boolean.TRUE);
        booleanDefaults.put("f", Boolean.FALSE);
        booleanDefaults.put("t", Boolean.TRUE);
        booleanDefaults.put("no", Boolean.FALSE);
        booleanDefaults.put("yes", Boolean.TRUE);
        booleanDefaults.put("n", Boolean.FALSE);
        booleanDefaults.put("y", Boolean.TRUE);
        booleanDefaults.put("off", Boolean.FALSE);
        booleanDefaults.put("on", Boolean.TRUE);
        booleanDefaults.put("x", Boolean.FALSE);
        booleanDefaults.put("o", Boolean.TRUE);
    }
}

