/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.csv.CsvListHandler;
import jp.sf.orangesignal.csv.CsvReader;
import jp.sf.orangesignal.csv.CsvWriter;

public class ColumnNameMapListHandler
implements CsvListHandler<Map<String, String>> {
    private List<String> columnNames;

    public ColumnNameMapListHandler addColumn(String columnName) {
        if (this.columnNames == null) {
            this.columnNames = new ArrayList<String>();
        }
        this.columnNames.add(columnName);
        return this;
    }

    public ColumnNameMapListHandler columnNames(Collection<String> columnNames) {
        this.columnNames = new ArrayList<String>(columnNames);
        return this;
    }

    @Override
    public List<Map<String, String>> load(CsvReader reader) throws IOException {
        List<String> values;
        if (this.columnNames == null) {
            this.columnNames = reader.readValues();
            if (this.columnNames == null) {
                throw new IOException("No header is available");
            }
        }
        int columnCount = this.columnNames.size();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(columnCount);
        for (String columnName : this.columnNames) {
            m.put(columnName, null);
        }
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
        while ((values = reader.readValues()) != null) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(m);
            int len = Math.min(columnCount, values.size());
            for (int pos = 0; pos < len; ++pos) {
                map.put(this.columnNames.get(pos), values.get(pos));
            }
            results.add(map);
        }
        return results;
    }

    @Override
    public void save(List<Map<String, String>> list, CsvWriter writer) throws IOException {
        if (this.columnNames == null) {
            for (Map<String, String> map : list) {
                if (map == null) continue;
                this.columnNames = new ArrayList<String>(map.keySet());
                break;
            }
        }
        if (this.columnNames == null) {
            throw new IOException("No header is available");
        }
        writer.writeValues(this.columnNames);
        int columnCount = this.columnNames.size();
        for (Map<String, String> map : list) {
            if (map == null) {
                writer.writeValues(null);
                continue;
            }
            String[] values = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                values[i] = map.get(this.columnNames.get(i));
            }
            writer.writeValues(Arrays.asList(values));
        }
    }
}

